/*
 * Decompiled with CFR 0.152.
 */
package swim.io.ws;

import swim.codec.Decoder;
import swim.http.HttpResponse;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.http.AbstractHttpRequester;
import swim.io.ws.WebSocket;
import swim.io.ws.WebSocketModem;
import swim.io.ws.WsSettings;
import swim.ws.WsDecoder;
import swim.ws.WsEncoder;
import swim.ws.WsEngine;
import swim.ws.WsEngineSettings;
import swim.ws.WsRequest;
import swim.ws.WsResponse;

public class WsUpgradeRequester
extends AbstractHttpRequester<Object> {
    final WebSocket<?, ?> webSocket;
    final WsRequest wsRequest;
    final WsSettings wsSettings;

    public WsUpgradeRequester(WebSocket<?, ?> webSocket, WsRequest wsRequest, WsSettings wsSettings) {
        this.webSocket = webSocket;
        this.wsRequest = wsRequest;
        this.wsSettings = wsSettings;
    }

    public final WebSocket<?, ?> webSocket() {
        return this.webSocket;
    }

    public final WsRequest wsRequest() {
        return this.wsRequest;
    }

    public final WsSettings wsSettings() {
        return this.wsSettings;
    }

    public WsUpgradeRequester wsSettings(WsSettings wsSettings) {
        return new WsUpgradeRequester(this.webSocket, this.wsRequest, wsSettings);
    }

    public IpSocket createSocket(WsEngine engine) {
        WebSocket<?, ?> socket = this.webSocket;
        WsDecoder decoder = engine.decoder();
        WsEncoder encoder = engine.encoder();
        return new IpSocketModem(new WebSocketModem(socket, this.wsSettings, decoder, encoder));
    }

    public Decoder<Object> contentDecoder(HttpResponse<?> httpResponse) {
        return Decoder.done();
    }

    public void doRequest() {
        this.writeRequest(this.wsRequest.httpRequest());
    }

    public void didRespond(HttpResponse<Object> httpResponse) {
        WsResponse wsResponse = this.wsRequest.accept(httpResponse, (WsEngineSettings)this.wsSettings);
        if (wsResponse != null) {
            WsEngine engine = wsResponse.clientEngine((WsEngineSettings)this.wsSettings);
            IpSocket socket = this.createSocket(engine);
            this.become(socket);
            this.webSocket.didConnect();
            this.webSocket.didUpgrade(this.wsRequest.httpRequest(), httpResponse);
        } else {
            this.close();
        }
    }

    public void didDisconnect() {
        this.webSocket.didDisconnect();
    }
}

