/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Decoder;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.Parser;
import swim.decipher.DecipherDecoder;
import swim.json.Json;
import swim.protobuf.Protobuf;
import swim.recon.Recon;
import swim.structure.Data;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.xml.Xml;

public class DecipherStructureDecoder
extends DecipherDecoder<Item, Value> {
    @Override
    public Parser<Value> xmlParser() {
        return Xml.structureParser().documentParser();
    }

    @Override
    public Parser<Value> parseXml(Input input) {
        return Xml.structureParser().parseDocument(input);
    }

    @Override
    public Parser<Value> jsonParser() {
        return Json.structureParser().objectParser();
    }

    @Override
    public Parser<Value> parseJson(Input input) {
        return Json.structureParser().parseObject(input);
    }

    @Override
    public Parser<Value> reconParser() {
        return Recon.structureParser().blockParser();
    }

    @Override
    public Parser<Value> parseRecon(Input input) {
        return Recon.structureParser().parseBlock(input);
    }

    @Override
    public Decoder<Value> protobufDecoder() {
        return Protobuf.structureDecoder().payloadDecoder();
    }

    @Override
    public Decoder<Value> decodeProtobuf(InputBuffer input) {
        return Protobuf.structureDecoder().decodePayload(input);
    }

    @Override
    public Output<Value> textOutput() {
        return Text.output();
    }

    @Override
    public Output<Value> dataOutput() {
        return Data.output();
    }
}

