/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.KeyEffect;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;

public abstract class AbstractMapInlet<K, V, O>
implements MapInlet<K, V, O> {
    protected MapOutlet<K, V, ? extends O> input = null;
    protected HashTrieMap<K, KeyEffect> effects = HashTrieMap.empty();
    protected int version = -1;

    public MapOutlet<K, V, ? extends O> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends O> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<K, V, ? extends O> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        MapOutlet<K, V, O> input = this.input;
        if (input != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public void disconnectOutputs() {
    }

    @Override
    public void invalidateOutputKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willInvalidateOutputKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateOutputKey(key, effect);
            this.didInvalidateOutputKey(key, effect);
        }
    }

    @Override
    public void invalidateOutput() {
        if (this.version >= 0) {
            this.willInvalidateOutput();
            this.version = -1;
            this.onInvalidateOutput();
            this.didInvalidateOutput();
        }
    }

    @Override
    public void reconcileOutputKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)((Object)(oldEffects = this.effects).get(key))) != null) {
            this.willReconcileOutputKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            if (this.input != null) {
                this.input.reconcileInputKey(key, version);
            }
            this.onReconcileOutputKey(key, effect, version);
            this.didReconcileOutputKey(key, effect, version);
        }
    }

    @Override
    public void reconcileOutput(int version) {
        if (this.version < 0) {
            this.willReconcileOutput(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.reconcileOutputKey(keys.next(), version);
            }
            this.version = version;
            this.onReconcileOutput(version);
            this.didReconcileOutput(version);
        }
    }

    protected void willInvalidateOutputKey(K key, KeyEffect effect) {
    }

    protected void onInvalidateOutputKey(K key, KeyEffect effect) {
    }

    protected void didInvalidateOutputKey(K key, KeyEffect effect) {
    }

    protected void willInvalidateOutput() {
    }

    protected void onInvalidateOutput() {
    }

    protected void didInvalidateOutput() {
    }

    protected void willReconcileOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void onReconcileOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void didReconcileOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void willReconcileOutput(int version) {
    }

    protected void onReconcileOutput(int version) {
    }

    protected void didReconcileOutput(int version) {
    }
}

