/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.Utf8;
import swim.codec.UtfErrorMode;
import swim.protobuf.FieldDecoder;
import swim.protobuf.Fixed32Decoder;
import swim.protobuf.Fixed64Decoder;
import swim.protobuf.MessageDecoder;
import swim.protobuf.PackedDecoder;
import swim.protobuf.PayloadDecoder;
import swim.protobuf.SizedDecoder;
import swim.protobuf.VarintDecoder;
import swim.protobuf.WireType;
import swim.util.Builder;

public abstract class ProtobufDecoder<I, V> {
    public abstract I item(V var1);

    public abstract V value(I var1);

    public abstract I field(long var1, V var3);

    public abstract V uint(long var1);

    public abstract V sint(long var1);

    public abstract V fixed(int var1);

    public abstract V fixed(long var1);

    public abstract Builder<I, V> messageBuilder();

    public abstract Output<V> dataOutput();

    public abstract Output<V> textOutput();

    public Decoder<V> decodeValue(WireType wireType, Decoder<V> payloadDecoder, InputBuffer input) {
        switch (wireType.code) {
            case 0: {
                return this.decodeVarint(input);
            }
            case 1: {
                return this.decodeFixed64(input);
            }
            case 2: {
                return this.decodeSized(payloadDecoder, input);
            }
            case 5: {
                return this.decodeFixed32(input);
            }
        }
        return Decoder.error((Throwable)new DecoderException("unsupported wire type: " + wireType.name()));
    }

    public Decoder<V> decodeValue(WireType wireType, InputBuffer input) {
        switch (wireType.code) {
            case 0: {
                return this.decodeVarint(input);
            }
            case 1: {
                return this.decodeFixed64(input);
            }
            case 2: {
                return this.decodeSized(this.payloadDecoder(), input);
            }
            case 5: {
                return this.decodeFixed32(input);
            }
        }
        return Decoder.error((Throwable)new DecoderException("unsupported wire type: " + wireType.name()));
    }

    public Decoder<V> decodeVarint(InputBuffer input) {
        return VarintDecoder.decode(input, this);
    }

    public Decoder<V> decodeSignedVarint(InputBuffer input) {
        return VarintDecoder.decodeSigned(input, this);
    }

    public Decoder<V> decodeFixed64(InputBuffer input) {
        return Fixed64Decoder.decode(input, this);
    }

    public Decoder<V> decodeSized(Decoder<V> payloadDecoder, InputBuffer input) {
        return SizedDecoder.decode(input, payloadDecoder);
    }

    public Decoder<V> decodeSized(InputBuffer input) {
        return this.decodeSized(this.payloadDecoder(), input);
    }

    public Decoder<V> decodeFixed32(InputBuffer input) {
        return Fixed32Decoder.decode(input, this);
    }

    public Decoder<I> decodeField(Decoder<V> payloadDecoder, InputBuffer input) {
        return FieldDecoder.decode(input, this, payloadDecoder);
    }

    public Decoder<V> decodeMessage(Decoder<V> payloadDecoder, InputBuffer input) {
        return MessageDecoder.decode(input, this, payloadDecoder);
    }

    public Decoder<V> decodeMessage(InputBuffer input) {
        return this.decodeMessage(this.payloadDecoder(), input);
    }

    public Decoder<V> decodePacked(WireType wireType, InputBuffer input) {
        return PackedDecoder.decode(input, this, wireType);
    }

    public Decoder<V> decodeText(InputBuffer input) {
        return Utf8.decodeOutput(this.textOutput(), (InputBuffer)input, (UtfErrorMode)UtfErrorMode.fatalNonZero());
    }

    public Decoder<V> decodeData(InputBuffer input) {
        return Binary.parseOutput(this.dataOutput(), (Input)input);
    }

    public Decoder<V> decodePayload(InputBuffer input) {
        return PayloadDecoder.decode(input, this);
    }

    public Decoder<V> payloadDecoder() {
        return new PayloadDecoder(this);
    }
}

