/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Encoder;
import swim.codec.OutputBuffer;

final class EncoderAndThen<I, O>
extends Encoder<I, O> {
    private final Encoder<I, ?> head;
    private final Encoder<I, O> tail;

    EncoderAndThen(Encoder<I, ?> head, Encoder<I, O> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Encoder<I, O> pull(OutputBuffer<?> output) {
        Encoder<I, ?> head = this.head;
        if (head.isCont()) {
            head = head.pull(output);
        }
        if (head.isDone()) {
            return this.tail;
        }
        if (head.isError()) {
            return head.asError();
        }
        return new EncoderAndThen<I, O>(head, this.tail);
    }
}

