/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import swim.codec.OutputBuffer;
import swim.codec.OutputException;
import swim.codec.OutputSettings;

final class OutputBufferError<T>
extends OutputBuffer<T> {
    final Throwable error;
    final OutputSettings settings;

    OutputBufferError(Throwable error, OutputSettings settings) {
        this.error = error;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public OutputBuffer<T> isPart(boolean isPart) {
        return this;
    }

    @Override
    public int index() {
        return 0;
    }

    @Override
    public OutputBuffer<T> index(int index) {
        if (index == 0) {
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid index"), this.settings);
    }

    @Override
    public int limit() {
        return 0;
    }

    @Override
    public OutputBuffer<T> limit(int limit) {
        if (limit == 0) {
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid limit"), this.settings);
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public int remaining() {
        return 0;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean has(int index) {
        return false;
    }

    @Override
    public int get(int index) {
        throw new OutputException();
    }

    @Override
    public void set(int index, int token) {
        throw new OutputException();
    }

    @Override
    public int write(ReadableByteChannel channel) throws IOException {
        return 0;
    }

    @Override
    public OutputBuffer<T> write(int token) {
        return this;
    }

    @Override
    public OutputBuffer<T> write(String string) {
        return this;
    }

    @Override
    public OutputBuffer<T> writeln(String string) {
        return this;
    }

    @Override
    public OutputBuffer<T> writeln() {
        return this;
    }

    @Override
    public OutputBuffer<T> move(int fromIndex, int toIndex, int length) {
        if (fromIndex == 0 && toIndex == 0 && length == 0) {
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid move"), this.settings);
    }

    @Override
    public OutputBuffer<T> step(int offset) {
        if (offset == 0) {
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid step"), this.settings);
    }

    @Override
    public T bind() {
        return null;
    }

    @Override
    public Throwable trap() {
        return this.error;
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public OutputBuffer<T> settings(OutputSettings settings) {
        return OutputBuffer.error(this.error, settings);
    }

    @Override
    public OutputBuffer<T> clone() {
        return this;
    }
}

