/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigInteger;
import swim.codec.Output;
import swim.structure.Item;
import swim.structure.NumF32;
import swim.structure.NumF64;
import swim.structure.NumI32;
import swim.structure.NumI64;
import swim.structure.NumInt;
import swim.structure.Value;
import swim.util.Murmur3;

public abstract class Num
extends Value {
    Num() {
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public boolean isUint32() {
        return false;
    }

    public boolean isUint64() {
        return false;
    }

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    public abstract boolean isValidByte();

    public abstract boolean isValidShort();

    public abstract boolean isValidInt();

    public abstract boolean isValidLong();

    public abstract boolean isValidFloat();

    public abstract boolean isValidDouble();

    public abstract boolean isValidInteger();

    @Override
    public abstract String stringValue();

    @Override
    public String stringValue(String orElse) {
        return this.stringValue();
    }

    @Override
    public abstract byte byteValue();

    @Override
    public byte byteValue(byte orElse) {
        return this.byteValue();
    }

    @Override
    public abstract short shortValue();

    @Override
    public short shortValue(short orElse) {
        return this.shortValue();
    }

    @Override
    public abstract int intValue();

    @Override
    public int intValue(int orElse) {
        return this.intValue();
    }

    @Override
    public abstract long longValue();

    @Override
    public long longValue(long orElse) {
        return this.longValue();
    }

    @Override
    public abstract float floatValue();

    @Override
    public float floatValue(float orElse) {
        return this.floatValue();
    }

    @Override
    public abstract double doubleValue();

    @Override
    public double doubleValue(double orElse) {
        return this.doubleValue();
    }

    @Override
    public abstract BigInteger integerValue();

    @Override
    public BigInteger integerValue(BigInteger orElse) {
        return this.integerValue();
    }

    @Override
    public abstract Number numberValue();

    @Override
    public Number numberValue(Number orElse) {
        return this.numberValue();
    }

    @Override
    public abstract char charValue();

    @Override
    public char charValue(char orElse) {
        return this.charValue();
    }

    @Override
    public abstract boolean booleanValue();

    @Override
    public boolean booleanValue(boolean orElse) {
        return this.booleanValue();
    }

    @Override
    public Value bitwiseOr(Value that) {
        if (that instanceof Num) {
            return this.bitwiseOr((Num)that);
        }
        return super.bitwiseOr(that);
    }

    public abstract Value bitwiseOr(Num var1);

    @Override
    public Value bitwiseXor(Value that) {
        if (that instanceof Num) {
            return this.bitwiseXor((Num)that);
        }
        return super.bitwiseXor(that);
    }

    public abstract Value bitwiseXor(Num var1);

    @Override
    public Value bitwiseAnd(Value that) {
        if (that instanceof Num) {
            return this.bitwiseAnd((Num)that);
        }
        return super.bitwiseAnd(that);
    }

    public abstract Value bitwiseAnd(Num var1);

    @Override
    public Value plus(Value that) {
        if (that instanceof Num) {
            return this.plus((Num)that);
        }
        return super.plus(that);
    }

    public abstract Num plus(Num var1);

    @Override
    public Value minus(Value that) {
        if (that instanceof Num) {
            return this.minus((Num)that);
        }
        return super.minus(that);
    }

    public abstract Num minus(Num var1);

    @Override
    public Value times(Value that) {
        if (that instanceof Num) {
            return this.times((Num)that);
        }
        return super.times(that);
    }

    public abstract Num times(Num var1);

    @Override
    public Value divide(Value that) {
        if (that instanceof Num) {
            return this.divide((Num)that);
        }
        return super.divide(that);
    }

    public abstract Num divide(Num var1);

    @Override
    public Value modulo(Value that) {
        if (that instanceof Num) {
            return this.modulo((Num)that);
        }
        return super.modulo(that);
    }

    public abstract Num modulo(Num var1);

    @Override
    public abstract Value bitwiseNot();

    @Override
    public abstract Num negative();

    @Override
    public Num positive() {
        return this;
    }

    @Override
    public abstract Num inverse();

    public abstract Num abs();

    public abstract Num ceil();

    public abstract Num floor();

    public abstract Num round();

    public abstract Num sqrt();

    public abstract Num pow(Num var1);

    public Num max(Num that) {
        return this.compareTo(that) >= 0 ? this : that;
    }

    public Num min(Num that) {
        return this.compareTo(that) <= 0 ? this : that;
    }

    @Override
    public int typeOrder() {
        return 6;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Num) {
            return this.compareTo((Num)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    public int compareTo(Num that) {
        if (this.isValidByte() && that.isValidByte()) {
            return Byte.compare(this.byteValue(), that.byteValue());
        }
        if (this.isValidShort() && that.isValidShort()) {
            return Short.compare(this.shortValue(), that.shortValue());
        }
        if (this.isValidInt() && that.isValidInt()) {
            return Integer.compare(this.intValue(), that.intValue());
        }
        if (this.isValidLong() && that.isValidLong()) {
            return Long.compare(this.longValue(), that.longValue());
        }
        if (this.isValidFloat() && that.isValidFloat()) {
            float y;
            float x = this.floatValue();
            return x < (y = that.floatValue()) ? -1 : (x > y ? 1 : (Float.isNaN(y) ? (Float.isNaN(x) ? 0 : -1) : (Float.isNaN(x) ? 1 : 0)));
        }
        if (this.isValidDouble() && that.isValidDouble()) {
            double y;
            double x = this.doubleValue();
            return x < (y = that.doubleValue()) ? -1 : (x > y ? 1 : (Double.isNaN(y) ? (Double.isNaN(x) ? 0 : -1) : (Double.isNaN(x) ? 1 : 0)));
        }
        return this.stringValue().compareTo(that.stringValue());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Num) {
            return this.equals((Num)other);
        }
        return false;
    }

    boolean equals(Num that) {
        if (this.isValidByte() && that.isValidByte()) {
            return this.byteValue() == that.byteValue();
        }
        if (this.isValidShort() && that.isValidShort()) {
            return this.shortValue() == that.shortValue();
        }
        if (this.isValidInt() && that.isValidInt()) {
            return this.intValue() == that.intValue();
        }
        if (this.isValidLong() && that.isValidLong()) {
            return this.longValue() == that.longValue();
        }
        if (this.isValidFloat() && that.isValidFloat()) {
            float y;
            float x = this.floatValue();
            return x == (y = that.floatValue()) || Float.isNaN(x) && Float.isNaN(y);
        }
        if (this.isValidDouble() && that.isValidDouble()) {
            double y;
            double x = this.doubleValue();
            return x == (y = that.doubleValue()) || Double.isNaN(x) && Double.isNaN(y);
        }
        return this.stringValue().equals(that.stringValue());
    }

    @Override
    public int hashCode() {
        if (this.isValidByte()) {
            return Murmur3.hash((byte)this.byteValue());
        }
        if (this.isValidShort()) {
            return Murmur3.hash((short)this.shortValue());
        }
        if (this.isValidInt()) {
            return Murmur3.hash((int)this.intValue());
        }
        if (this.isValidLong()) {
            return Murmur3.hash((long)this.longValue());
        }
        if (this.isValidFloat()) {
            return Murmur3.hash((float)this.floatValue());
        }
        if (this.isValidDouble()) {
            return Murmur3.hash((double)this.doubleValue());
        }
        return this.stringValue().hashCode();
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Num").write(46).write("from").write(40).display((Object)this).write(41);
    }

    @Override
    public abstract void display(Output<?> var1);

    public static Num from(int value) {
        return NumI32.from(value);
    }

    public static Num from(long value) {
        return NumI64.from(value);
    }

    public static Num from(float value) {
        return NumF32.from(value);
    }

    public static Num from(double value) {
        return NumF64.from(value);
    }

    public static Num from(BigInteger value) {
        return NumInt.from(value);
    }

    public static Num from(Number value) {
        if (value instanceof Byte) {
            return Num.from(value.byteValue());
        }
        if (value instanceof Short) {
            return Num.from(value.shortValue());
        }
        if (value instanceof Integer) {
            return Num.from(value.intValue());
        }
        if (value instanceof Long) {
            return Num.from(value.longValue());
        }
        if (value instanceof Float) {
            return Num.from(value.floatValue());
        }
        if (value instanceof Double) {
            return Num.from(value.doubleValue());
        }
        if (value instanceof BigInteger) {
            return Num.from((BigInteger)value);
        }
        return Num.from(value.doubleValue());
    }

    public static Num from(char value) {
        return NumI32.from((int)value);
    }

    public static Num from(String value) {
        if ("NaN".equals(value)) {
            return NumF64.nan();
        }
        try {
            long longValue = Long.parseLong(value);
            if ((long)((int)longValue) == longValue) {
                return Num.from((int)longValue);
            }
            return Num.from(longValue);
        }
        catch (NumberFormatException e1) {
            try {
                double doubleValue = Double.parseDouble(value);
                if ((double)((float)doubleValue) == doubleValue) {
                    return Num.from((float)doubleValue);
                }
                return Num.from(doubleValue);
            }
            catch (NumberFormatException e2) {
                return Num.from(new BigInteger(value));
            }
        }
    }

    public static Num uint32(int value) {
        return NumI32.uint32(value);
    }

    public static Num uint64(long value) {
        return NumI64.uint64(value);
    }
}

