/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class FloatForm
extends Form<Float> {
    final Float unit;

    public FloatForm(Float unit) {
        this.unit = unit;
    }

    @Override
    public Float unit() {
        return this.unit;
    }

    @Override
    public Form<Float> unit(Float unit) {
        return new FloatForm(unit);
    }

    @Override
    public Class<Float> type() {
        return Float.class;
    }

    @Override
    public Item mold(Float value) {
        if (value != null) {
            return Num.from(value.floatValue());
        }
        return Item.extant();
    }

    @Override
    public Float cast(Item item) {
        Value value = item.target();
        try {
            return Float.valueOf(value.floatValue());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

