/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.lang.reflect.Constructor;
import java.util.Map;
import swim.structure.Field;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public final class MapForm<K, V>
extends Form<Map<K, V>> {
    final Class<?> type;
    final Form<K> keyForm;
    final Form<V> valForm;
    final Constructor<Map<K, V>> constructor;

    public MapForm(Class<?> type, Form<K> keyForm, Form<V> valForm) {
        this.type = type;
        this.keyForm = keyForm;
        this.valForm = valForm;
        try {
            this.constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException cause) {
            throw new FormException(cause);
        }
    }

    @Override
    public Map<K, V> unit() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException cause) {
            throw new FormException(cause);
        }
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public Item mold(Map<K, V> map, Item item) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Value key = this.keyForm.mold(entry.getKey()).toValue();
                Value val = this.valForm.mold(entry.getValue()).toValue();
                item = item.updatedSlot(key, val);
            }
            return item;
        }
        return Item.extant();
    }

    @Override
    public Item mold(Map<K, V> map) {
        if (map != null) {
            Record record = Record.create();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Value key = this.keyForm.mold(entry.getKey()).toValue();
                Value val = this.valForm.mold(entry.getValue()).toValue();
                record.slot(key, val);
            }
            return record;
        }
        return Item.extant();
    }

    @Override
    public Map<K, V> cast(Item item, Map<K, V> map) {
        Value value = item.toValue();
        for (Item child : value) {
            V val;
            K key;
            if (!(child instanceof Field) || (key = this.keyForm.cast(child.key())) == null || (val = this.valForm.cast(child.toValue())) == null) continue;
            map.put(key, val);
        }
        return map;
    }

    @Override
    public Map<K, V> cast(Item item) {
        Value value = item.toValue();
        int n = value.length();
        if (value instanceof Record) {
            Map<K, V> map;
            try {
                map = this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException cause) {
                throw new FormException(cause);
            }
            for (Item child : value) {
                V val;
                K key;
                if (!(child instanceof Field) || (key = this.keyForm.cast(child.key())) == null || (val = this.valForm.cast(child.toValue())) == null) continue;
                map.put(key, val);
            }
            return map;
        }
        return null;
    }
}

