/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.header.Connection;
import swim.io.FlowContext;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpContext;
import swim.io.IpSocket;
import swim.io.http.HttpResponder;
import swim.io.http.HttpServer;
import swim.io.http.HttpServerContext;
import swim.io.http.HttpSettings;

public abstract class AbstractHttpServer
implements HttpServer,
IpContext,
FlowContext {
    protected HttpServerContext context;

    @Override
    public HttpServerContext httpServerContext() {
        return this.context;
    }

    @Override
    public void setHttpServerContext(HttpServerContext context) {
        this.context = context;
    }

    @Override
    public long idleTimeout() {
        return -1L;
    }

    @Override
    public abstract HttpResponder<?> doRequest(HttpRequest<?> var1);

    @Override
    public void willRequest(HttpRequest<?> request) {
    }

    @Override
    public void didRequest(HttpRequest<?> request) {
        Connection connection = (Connection)request.getHeader(Connection.class);
        if (connection != null) {
            if (connection.contains("close")) {
                this.close();
                return;
            }
            if (connection.contains("Upgrade")) {
                return;
            }
        }
        this.context.readRequest();
    }

    @Override
    public void willRespond(HttpResponse<?> response) {
    }

    @Override
    public void didRespond(HttpResponse<?> response) {
    }

    @Override
    public void didConnect() {
        this.context.readRequest();
    }

    @Override
    public void willSecure() {
    }

    @Override
    public void didSecure() {
    }

    @Override
    public void willBecome(IpSocket socket) {
    }

    @Override
    public void didBecome(IpSocket socket) {
    }

    @Override
    public void didTimeout() {
    }

    @Override
    public void didDisconnect() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public boolean isConnected() {
        return this.context.isConnected();
    }

    public boolean isClient() {
        return this.context.isClient();
    }

    public boolean isServer() {
        return this.context.isServer();
    }

    public boolean isSecure() {
        return this.context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    public HttpSettings httpSettings() {
        return this.context.httpSettings();
    }

    public void readRequest() {
        this.context.readRequest();
    }

    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    public void close() {
        this.context.close();
    }
}

