/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.BoxR2;
import swim.math.BoxZ2;
import swim.math.CircleR2Form;
import swim.math.PointR2;
import swim.math.R2Form;
import swim.math.R2Shape;
import swim.math.R2ToZ2Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class CircleR2
extends R2Shape
implements Debug {
    public final double cx;
    public final double cy;
    public final double r;
    private static int hashSeed;
    private static R2Form<CircleR2> form;

    public CircleR2(double cx, double cy, double r) {
        this.cx = cx;
        this.cy = cy;
        this.r = r;
    }

    @Override
    public final double xMin() {
        return this.cx - this.r;
    }

    @Override
    public final double yMin() {
        return this.cy - this.r;
    }

    @Override
    public final double xMax() {
        return this.cx + this.r;
    }

    @Override
    public final double yMax() {
        return this.cy + this.r;
    }

    @Override
    public boolean contains(R2Shape shape) {
        if (shape instanceof PointR2) {
            return this.contains((PointR2)shape);
        }
        if (shape instanceof BoxR2) {
            return this.contains((BoxR2)shape);
        }
        if (shape instanceof CircleR2) {
            return this.contains((CircleR2)shape);
        }
        return false;
    }

    public boolean contains(PointR2 point) {
        double dx = point.x - this.cx;
        double dy = point.y - this.cy;
        return dx * dx + dy * dy <= this.r * this.r;
    }

    public boolean contains(BoxR2 box) {
        double dxMin = box.xMin - this.cx;
        double dyMin = box.yMin - this.cy;
        double dxMax = box.xMax - this.cx;
        double dyMax = box.yMax - this.cy;
        double r2 = this.r * this.r;
        return dxMin * dxMin + dyMin * dyMin <= r2 && dxMin * dxMin + dyMax * dyMax <= r2 && dxMax * dxMax + dyMin * dyMin <= r2 && dxMax * dxMax + dyMax * dyMax <= r2;
    }

    public boolean contains(CircleR2 circle) {
        double dx = circle.cx - this.cx;
        double dy = circle.cy - this.cy;
        return dx * dx + dy * dy + circle.r * circle.r <= this.r * this.r;
    }

    @Override
    public boolean intersects(R2Shape shape) {
        if (shape instanceof PointR2) {
            return this.intersects((PointR2)shape);
        }
        if (shape instanceof BoxR2) {
            return this.intersects((BoxR2)shape);
        }
        if (shape instanceof CircleR2) {
            return this.intersects((CircleR2)shape);
        }
        return shape.intersects(this);
    }

    public boolean intersects(PointR2 point) {
        double dx = point.x - this.cx;
        double dy = point.y - this.cy;
        return dx * dx + dy * dy <= this.r * this.r;
    }

    public boolean intersects(BoxR2 box) {
        double dx = (this.cx < box.xMin ? box.xMin : (box.xMax < this.cx ? box.xMax : this.cx)) - this.cx;
        double dy = (this.cy < box.yMin ? box.yMin : (box.yMax < this.cy ? box.yMax : this.cy)) - this.cy;
        return dx * dx + dy * dy <= this.r * this.r;
    }

    public boolean intersects(CircleR2 circle) {
        double dx = circle.cx - this.cx;
        double dy = circle.cy - this.cy;
        double rr = this.r + circle.r;
        return dx * dx + dy * dy <= rr * rr;
    }

    @Override
    public BoxZ2 transform(R2ToZ2Function f) {
        double xMin = this.cx - this.r;
        double yMin = this.cy - this.r;
        double xMax = this.cx + this.r;
        double yMax = this.cy + this.r;
        return new BoxZ2(f.transformX(xMin, yMin), f.transformY(xMin, yMin), f.transformX(xMax, yMax), f.transformY(xMax, yMax));
    }

    @Override
    public Value toValue() {
        return CircleR2.form().mold(this).toValue();
    }

    protected boolean canEqual(CircleR2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CircleR2) {
            CircleR2 that = (CircleR2)other;
            return that.canEqual(this) && this.cx == that.cx && this.cy == that.cy && this.r == that.r;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(CircleR2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((double)this.cx)), (int)Murmur3.hash((double)this.cy)), (int)Murmur3.hash((double)this.r)));
    }

    public void debug(Output<?> output) {
        output.write("CircleR2").write(46).write("of").write(40).debug((Object)this.cx).write(", ").debug((Object)this.cy).write(", ").debug((Object)this.r).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static CircleR2 of(double cx, double cy, double r) {
        return new CircleR2(cx, cy, r);
    }

    @Kind
    public static R2Form<CircleR2> form() {
        if (form == null) {
            form = new CircleR2Form();
        }
        return form;
    }
}

