/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.MutableTensor;
import swim.math.Precision;
import swim.math.Random;
import swim.math.TensorDims;
import swim.math.UniformDistribution;

public abstract class Distribution {
    public abstract double density(double var1);

    public abstract double sample();

    public MutableTensor sample(TensorDims dims, Precision prec) {
        if (prec.isDouble()) {
            double[] us = new double[dims.size * dims.stride];
            this.sample(dims, us, 0);
            return new MutableTensor(dims, us);
        }
        if (prec.isSingle()) {
            float[] us = new float[dims.size * dims.stride];
            this.sample(dims, us, 0);
            return new MutableTensor(dims, us);
        }
        throw new IllegalArgumentException(prec.toString());
    }

    void sample(TensorDims ud, double[] us, int ui) {
        int un = ui + ud.size * ud.stride;
        if (ud.next != null) {
            while (ui < un) {
                this.sample(ud.next, us, ui);
                ui += ud.stride;
            }
        } else {
            while (ui < un) {
                us[ui] = this.sample();
                ui += ud.stride;
            }
        }
    }

    void sample(TensorDims ud, float[] us, int ui) {
        int un = ui + ud.size * ud.stride;
        if (ud.next != null) {
            while (ui < un) {
                this.sample(ud.next, us, ui);
                ui += ud.stride;
            }
        } else {
            while (ui < un) {
                us[ui] = (float)this.sample();
                ui += ud.stride;
            }
        }
    }

    public static Distribution sigmoidUniform(Random random, double fanIn, double fanOut) {
        double r = 4.0 * Math.sqrt(6.0 / (fanIn + fanOut));
        return new UniformDistribution(-r, r);
    }

    public static Distribution sigmoidUniform(double fanIn, double fanOut) {
        return Distribution.sigmoidUniform(Random.get(), fanIn, fanOut);
    }

    public static Distribution reluUniform(Random random, double fanIn, double fanOut) {
        double u = Math.sqrt(6.0 / fanIn);
        return new UniformDistribution(-u, u);
    }

    public static Distribution reluUniform(double fanIn, double fanOut) {
        return Distribution.reluUniform(Random.get(), fanIn, fanOut);
    }
}

