/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.Precision;
import swim.math.Tensor;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.structure.Item;

final class TensorObjectForm
extends TensorForm<Tensor> {
    final TensorDims dims;
    final Precision prec;

    TensorObjectForm(TensorDims dims, Precision prec) {
        this.dims = dims;
        this.prec = prec;
    }

    public String tag() {
        return "tensor";
    }

    public Tensor unit() {
        return Tensor.zero(this.dims);
    }

    public Class<?> type() {
        return Tensor.class;
    }

    public Item mold(Tensor tensor) {
        if (tensor != null) {
            return Tensor.mold(this.tag(), tensor);
        }
        return Item.extant();
    }

    public Tensor cast(Item item) {
        return Tensor.cast(this.tag(), (Item)item.toValue(), this.dims, this.prec);
    }

    @Override
    public Tensor fromTensor(TensorDims ud, float[] us, int ui) {
        if (this.prec.isDouble()) {
            double[] ws = new double[this.dims.size * this.dims.stride];
            Tensor.copy(ud, us, ui, this.dims, ws, 0);
            return new Tensor(this.dims, us);
        }
        if (this.prec.isSingle()) {
            float[] ws = new float[this.dims.size * this.dims.stride];
            Tensor.copy(ud, us, ui, this.dims, ws, 0);
            return new Tensor(this.dims, us);
        }
        throw new AssertionError();
    }

    @Override
    public Tensor fromTensor(TensorDims ud, double[] us, int ui) {
        if (this.prec.isDouble()) {
            double[] ws = new double[this.dims.size * this.dims.stride];
            Tensor.copy(ud, us, ui, this.dims, ws, 0);
            return new Tensor(this.dims, us);
        }
        if (this.prec.isSingle()) {
            float[] ws = new float[this.dims.size * this.dims.stride];
            Tensor.copy(ud, us, ui, this.dims, ws, 0);
            return new Tensor(this.dims, us);
        }
        throw new AssertionError();
    }

    @Override
    public void toTensor(Tensor u, TensorDims wd, float[] ws, int wi) {
        Object us = u.array;
        if (us instanceof double[]) {
            Tensor.copy(u.dims, (double[])us, 0, wd, ws, wi);
        } else if (us instanceof float[]) {
            Tensor.copy(u.dims, (float[])us, 0, wd, ws, wi);
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public void toTensor(Tensor u, TensorDims wd, double[] ws, int wi) {
        Object us = u.array;
        if (us instanceof double[]) {
            Tensor.copy(u.dims, (double[])us, 0, wd, ws, wi);
        } else if (us instanceof float[]) {
            Tensor.copy(u.dims, (float[])us, 0, wd, ws, wi);
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public Item moldTensor(TensorDims ud, float[] us, int ui) {
        return Tensor.mold(this.tag(), ud, us, ui);
    }

    @Override
    public Item moldTensor(TensorDims ud, double[] us, int ui) {
        return Tensor.mold(this.tag(), ud, us, ui);
    }

    @Override
    public void castTensor(Item item, TensorDims wd, float[] ws, int wi) {
        Tensor.cast(this.tag(), (Item)item.toValue(), wd, ws, wi);
    }

    @Override
    public void castTensor(Item item, TensorDims wd, double[] ws, int wi) {
        Tensor.cast(this.tag(), (Item)item.toValue(), wd, ws, wi);
    }
}

