/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.ws.WsDecoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

final class WsFrameDecoder<O>
extends Decoder<WsFrame<O>> {
    final WsDecoder ws;
    final Decoder<O> content;
    final int finRsvOp;
    final long position;
    final long offset;
    final long length;
    final byte[] maskingKey;
    final int step;

    WsFrameDecoder(WsDecoder ws, Decoder<O> content, int finRsvOp, long position, long offset, long length, byte[] maskingKey, int step) {
        this.ws = ws;
        this.position = position;
        this.content = content;
        this.finRsvOp = finRsvOp;
        this.offset = offset;
        this.length = length;
        this.maskingKey = maskingKey;
        this.step = step;
    }

    WsFrameDecoder(WsDecoder ws, Decoder<O> content) {
        this(ws, content, 0, 0L, 0L, 0L, null, 1);
    }

    public Decoder<WsFrame<O>> feed(InputBuffer input) {
        return WsFrameDecoder.decode(input, this.ws, this.content, this.finRsvOp, this.position, this.offset, this.length, this.maskingKey, this.step);
    }

    static <O> Decoder<WsFrame<O>> decode(InputBuffer input, WsDecoder ws, Decoder<O> content, int finRsvOp, long position, long offset, long length, byte[] maskingKey, int step) {
        if (step == 1 && input.isCont()) {
            finRsvOp = input.head();
            input = input.step();
            step = 2;
        }
        if (step == 2 && input.isCont()) {
            int len;
            int maskLength = input.head();
            input = input.step();
            if ((maskLength & 0x80) != 0) {
                maskingKey = new byte[4];
            }
            if ((len = maskLength & 0x7F) == 126) {
                step = 3;
            } else if (len == 127) {
                step = 5;
            } else {
                length = len;
                int n = step = maskingKey != null ? 13 : 17;
            }
        }
        if (step >= 3 && step <= 4) {
            while (input.isCont()) {
                length = length << 8 | (long)input.head();
                input = input.step();
                if (step < 4) {
                    ++step;
                    continue;
                }
                int n = step = maskingKey != null ? 13 : 17;
                break;
            }
        }
        if (step >= 5 && step <= 12) {
            while (input.isCont()) {
                length = length << 8 | (long)input.head();
                input = input.step();
                if (step < 12) {
                    ++step;
                    continue;
                }
                int n = step = maskingKey != null ? 13 : 17;
                break;
            }
        }
        if (step >= 13 && step <= 16) {
            while (input.isCont()) {
                maskingKey[step - 13] = (byte)input.head();
                input = input.step();
                if (step < 16) {
                    ++step;
                    continue;
                }
                step = 17;
                break;
            }
        }
        if (step == 17) {
            int opcode;
            int base = input.index();
            int size = (int)Math.min(length - offset, (long)input.remaining());
            if (maskingKey != null) {
                for (int i = 0; i < size; ++i) {
                    input.set(base + i, (input.get(base + i) ^ maskingKey[(int)(position + (long)i) & 3]) & 0xFF);
                }
            }
            position += (long)size;
            boolean eof = (offset += (long)size) == length && (finRsvOp & 0x80) != 0;
            boolean inputPart = input.isPart();
            if ((input = input.isPart(!eof)).remaining() < size) {
                content = content.feed(input);
            } else {
                int inputLimit = input.limit();
                input = input.limit(base + size);
                content = content.feed(input);
                input = input.limit(inputLimit);
            }
            input = input.isPart(inputPart);
            if (input.index() != base + size) {
                return WsFrameDecoder.error((Throwable)new DecoderException("undecoded websocket data"));
            }
            if (content.isError()) {
                return content.asError();
            }
            if (content.isDone()) {
                if (offset == length) {
                    if ((finRsvOp & 0x80) != 0) {
                        opcode = finRsvOp & 0xF;
                        if (opcode < 8) {
                            return WsFrameDecoder.done(ws.message(content.bind()));
                        }
                        return WsFrameDecoder.done(ws.control(WsOpcode.from(opcode), content.bind()));
                    }
                    return WsFrameDecoder.error((Throwable)new DecoderException("decoded unfinished websocket message"));
                }
                return WsFrameDecoder.error((Throwable)new DecoderException("decoded incomplete websocket frame"));
            }
            if (offset == length) {
                if ((finRsvOp & 0x80) == 0) {
                    opcode = finRsvOp & 0xF;
                    if (opcode < 8) {
                        return WsFrameDecoder.done(ws.fragment(WsOpcode.from(opcode), content));
                    }
                    return WsFrameDecoder.error((Throwable)new DecoderException("decoded fragmented control frame"));
                }
                return WsFrameDecoder.error((Throwable)new DecoderException("undecoded websocket message"));
            }
        }
        if (input.isDone()) {
            return WsFrameDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return WsFrameDecoder.error((Throwable)input.trap());
        }
        return new WsFrameDecoder<O>(ws, content, finRsvOp, position, offset, length, maskingKey, step);
    }

    static <O> Decoder<WsFrame<O>> decode(InputBuffer input, WsDecoder ws, Decoder<O> content) {
        return WsFrameDecoder.decode(input, ws, content, 0, 0L, 0L, 0L, null, 1);
    }
}

