/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.util.Murmur3;
import swim.ws.WsData;
import swim.ws.WsEncoder;
import swim.ws.WsOpcode;

public final class WsValue<T>
extends WsData<T>
implements Debug {
    final T value;
    private static int hashSeed;

    WsValue(T value) {
        this.value = value;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public WsOpcode opcode() {
        return WsOpcode.INVALID;
    }

    @Override
    public Object payload() {
        return this.value;
    }

    @Override
    public Encoder<?, ?> contentEncoder(WsEncoder ws) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder<?, ?> encodeContent(OutputBuffer<?> output, WsEncoder ws) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsValue) {
            WsValue that = (WsValue)other;
            return this.value == null ? that.value == null : this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsValue.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)));
    }

    public void debug(Output<?> output) {
        output = output.write("WsValue").write(46).write("from").write(40).debug(this.value).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> WsValue<T> from(T value) {
        return new WsValue<T>(value);
    }
}

