/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class ComparisonOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> lhsParser;
    final String operator;
    final Parser<V> rhsParser;
    final int step;

    ComparisonOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.lhsParser = lhsParser;
        this.operator = operator;
        this.rhsParser = rhsParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return ComparisonOperatorParser.parse(input, this.recon, this.builder, this.lhsParser, this.operator, this.rhsParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        int c = 0;
        if (step == 1) {
            if (lhsParser == null) {
                lhsParser = recon.parseAttrExpression(input, builder);
            }
            while (lhsParser.isCont() && !input.isEmpty()) {
                lhsParser = lhsParser.feed(input);
            }
            if (lhsParser.isDone()) {
                step = 2;
            } else if (lhsParser.isError()) {
                return lhsParser.asError();
            }
        }
        if (step == 2) {
            while (input.isCont() && Recon.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 33) {
                    input = input.step();
                    step = 3;
                } else if (c == 60) {
                    input = input.step();
                    step = 4;
                } else if (c == 62) {
                    input = input.step();
                    step = 5;
                } else {
                    if (c != 61) return lhsParser;
                    input = input.step();
                    step = 6;
                }
            } else if (input.isDone()) {
                return lhsParser;
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    operator = "!=";
                    step = 7;
                } else {
                    operator = "!";
                    step = 7;
                }
            } else if (input.isDone()) {
                return ComparisonOperatorParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 4) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    operator = "<=";
                    step = 7;
                } else {
                    operator = "<";
                    step = 7;
                }
            } else if (input.isDone()) {
                return ComparisonOperatorParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    operator = ">=";
                    step = 7;
                } else {
                    operator = ">";
                    step = 7;
                }
            } else if (input.isDone()) {
                return ComparisonOperatorParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 6) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    operator = "==";
                    step = 7;
                } else {
                    if (c == 62) {
                        return lhsParser;
                    }
                    operator = "=";
                    step = 7;
                }
            } else if (input.isDone()) {
                return ComparisonOperatorParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 7) {
            if (rhsParser == null) {
                rhsParser = recon.parseAttrExpression(input, builder);
            }
            while (rhsParser.isCont() && !input.isEmpty()) {
                rhsParser = rhsParser.feed(input);
            }
            if (rhsParser.isDone()) {
                Object lhs = lhsParser.bind();
                Object rhs = rhsParser.bind();
                if ("<".equals(operator)) {
                    return ComparisonOperatorParser.done((Object)recon.lt(lhs, rhs));
                }
                if ("<=".equals(operator)) {
                    return ComparisonOperatorParser.done((Object)recon.le(lhs, rhs));
                }
                if ("==".equals(operator)) {
                    return ComparisonOperatorParser.done((Object)recon.eq(lhs, rhs));
                }
                if ("!=".equals(operator)) {
                    return ComparisonOperatorParser.done((Object)recon.ne(lhs, rhs));
                }
                if (">=".equals(operator)) {
                    return ComparisonOperatorParser.done((Object)recon.ge(lhs, rhs));
                }
                if (!">".equals(operator)) return ComparisonOperatorParser.error((Diagnostic)Diagnostic.message((String)operator, (Input)input));
                return ComparisonOperatorParser.done((Object)recon.gt(lhs, rhs));
            }
            if (rhsParser.isError()) {
                return rhsParser.asError();
            }
        }
        if (!input.isError()) return new ComparisonOperatorParser<I, Object>(recon, builder, lhsParser, operator, rhsParser, step);
        return ComparisonOperatorParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return ComparisonOperatorParser.parse(input, recon, builder, null, null, null, 1);
    }
}

