/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.recon.ReconParser;
import swim.util.Builder;

final class MarkupParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Output<V> textOutput;
    final Parser<V> valueParser;
    final int step;

    MarkupParser(ReconParser<I, V> recon, Builder<I, V> builder, Output<V> textOutput, Parser<V> valueParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.textOutput = textOutput;
        this.valueParser = valueParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return MarkupParser.parse(input, this.recon, this.builder, this.textOutput, this.valueParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Output<V> textOutput, Parser<V> valueParser, int step) {
        block40: {
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (c != 91) return MarkupParser.error((Diagnostic)Diagnostic.expected((int)91, (Input)input));
                    input = input.step();
                    step = 2;
                } else if (input.isDone()) {
                    return MarkupParser.error((Diagnostic)Diagnostic.expected((int)91, (Input)input));
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && (c = input.head()) != 64 && c != 91 && c != 92 && c != 93 && c != 123 && c != 125) {
                        input = input.step();
                        if (textOutput == null) {
                            textOutput = recon.textOutput();
                        }
                        textOutput.write(c);
                    }
                    if (input.isCont()) {
                        if (c == 93) {
                            input = input.step();
                            if (builder == null) {
                                builder = recon.recordBuilder();
                            }
                            if (textOutput == null) return MarkupParser.done((Object)builder.bind());
                            builder.add(recon.item(textOutput.bind()));
                            return MarkupParser.done((Object)builder.bind());
                        }
                        if (c == 64) {
                            if (builder == null) {
                                builder = recon.recordBuilder();
                            }
                            if (textOutput != null) {
                                builder.add(recon.item(textOutput.bind()));
                                textOutput = null;
                            }
                            valueParser = recon.parseInlineItem(input);
                            step = 3;
                        } else if (c == 123) {
                            if (builder == null) {
                                builder = recon.recordBuilder();
                            }
                            if (textOutput != null) {
                                builder.add(recon.item(textOutput.bind()));
                                textOutput = null;
                            }
                            valueParser = recon.parseRecord(input, (Builder<I, Object>)builder);
                            step = 4;
                        } else if (c == 91) {
                            if (builder == null) {
                                builder = recon.recordBuilder();
                            }
                            if (textOutput != null) {
                                builder.add(recon.item(textOutput.bind()));
                                textOutput = null;
                            }
                            valueParser = recon.parseMarkup(input, (Builder<I, Object>)builder);
                            step = 4;
                        } else {
                            if (c != 92) return MarkupParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                            input = input.step();
                            step = 5;
                        }
                    } else if (input.isDone()) {
                        return MarkupParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 3) {
                    while (valueParser.isCont() && !input.isEmpty()) {
                        valueParser = valueParser.feed(input);
                    }
                    if (valueParser.isDone()) {
                        builder.add(recon.item(valueParser.bind()));
                        valueParser = null;
                        step = 2;
                        continue;
                    }
                    if (valueParser.isError()) {
                        return valueParser;
                    }
                }
                if (step == 4) {
                    while (valueParser.isCont() && !input.isEmpty()) {
                        valueParser = valueParser.feed(input);
                    }
                    if (valueParser.isDone()) {
                        valueParser = null;
                        step = 2;
                        continue;
                    }
                    if (valueParser.isError()) {
                        return valueParser;
                    }
                }
                if (step != 5) break block40;
                if (!input.isCont()) break;
                c = input.head();
                if (textOutput == null) {
                    textOutput = recon.textOutput();
                }
                if (c == 34 || c == 36 || c == 39 || c == 47 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125) {
                    input = input.step();
                    textOutput.write(c);
                    step = 2;
                    continue;
                }
                if (c == 98) {
                    input = input.step();
                    textOutput.write(8);
                    step = 2;
                    continue;
                }
                if (c == 102) {
                    input = input.step();
                    textOutput.write(12);
                    step = 2;
                    continue;
                }
                if (c == 110) {
                    input = input.step();
                    textOutput.write(10);
                    step = 2;
                    continue;
                }
                if (c == 114) {
                    input = input.step();
                    textOutput.write(13);
                    step = 2;
                    continue;
                }
                if (c != 116) return MarkupParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                textOutput.write(9);
                step = 2;
            }
            if (input.isDone()) {
                return MarkupParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new MarkupParser<I, Object>(recon, builder, (Output<Object>)textOutput, valueParser, step);
        return MarkupParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return MarkupParser.parse(input, recon, builder, null, null, 1);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return MarkupParser.parse(input, recon, null, null, null, 1);
    }
}

