/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class RecordParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> keyParser;
    final Parser<V> valueParser;
    final int step;

    RecordParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.keyParser = keyParser;
        this.valueParser = valueParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return RecordParser.parse(input, this.recon, this.builder, this.keyParser, this.valueParser, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> keyParser, Parser<V> valueParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c != 123) {
                    return RecordParser.error((Diagnostic)Diagnostic.expected((int)123, (Input)input));
                }
                input = input.step();
                step = 2;
            } else if (input.isDone()) {
                return RecordParser.error((Diagnostic)Diagnostic.expected((int)123, (Input)input));
            }
        }
        block0: while (true) {
            block52: {
                if (step == 2) {
                    while (input.isCont() && Recon.isWhitespace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (builder == null) {
                            builder = recon.recordBuilder();
                        }
                        if (c == 125) {
                            input = input.step();
                            return RecordParser.done((Object)builder.bind());
                        }
                        if (c == 35) {
                            input = input.step();
                            step = 8;
                        } else {
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return RecordParser.error((Diagnostic)Diagnostic.expected((int)125, (Input)input));
                    }
                }
                if (step == 3) {
                    if (keyParser == null) {
                        keyParser = recon.parseBlockExpression(input);
                    }
                    while (keyParser.isCont() && !input.isEmpty()) {
                        keyParser = keyParser.feed(input);
                    }
                    if (keyParser.isDone()) {
                        step = 4;
                    } else if (keyParser.isError()) {
                        return keyParser;
                    }
                }
                if (step == 4) {
                    while (input.isCont() && Recon.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (c == 58) {
                            input = input.step();
                            step = 5;
                        } else {
                            builder.add(recon.item(keyParser.bind()));
                            keyParser = null;
                            step = 7;
                        }
                    } else if (input.isDone()) {
                        return RecordParser.error((Diagnostic)Diagnostic.expected((int)125, (Input)input));
                    }
                }
                if (step == 5) {
                    while (input.isCont() && Recon.isSpace(input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 6;
                    } else if (input.isDone()) {
                        builder.add(recon.slot(keyParser.bind()));
                        return RecordParser.done((Object)builder.bind());
                    }
                }
                if (step == 6) {
                    if (valueParser == null) {
                        valueParser = recon.parseBlockExpression(input);
                    }
                    while (valueParser.isCont() && !input.isEmpty()) {
                        valueParser = valueParser.feed(input);
                    }
                    if (valueParser.isDone()) {
                        builder.add(recon.slot(keyParser.bind(), valueParser.bind()));
                        keyParser = null;
                        valueParser = null;
                        step = 7;
                    } else if (valueParser.isError()) {
                        return valueParser;
                    }
                }
                if (step == 7) {
                    while (input.isCont() && Recon.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (c == 44 || c == 59 || Recon.isNewline(c)) {
                            input = input.step();
                            step = 2;
                            continue;
                        }
                        if (c == 35) {
                            input = input.step();
                            step = 8;
                            break block52;
                        } else {
                            if (c == 125) {
                                input = input.step();
                                return RecordParser.done((Object)builder.bind());
                            }
                            return RecordParser.error((Diagnostic)Diagnostic.expected((String)"'}', ';', ',', or newline", (Input)input));
                        }
                    }
                    if (input.isDone()) {
                        return RecordParser.error((Diagnostic)Diagnostic.expected((int)125, (Input)input));
                    }
                }
            }
            if (step != 8) break;
            while (input.isCont()) {
                c = input.head();
                if (!Recon.isNewline(c)) {
                    input = input.step();
                    continue;
                }
                step = 2;
                continue block0;
            }
            if (!input.isDone()) break;
            step = 2;
        }
        if (input.isError()) {
            return RecordParser.error((Throwable)input.trap());
        }
        return new RecordParser<I, Object>(recon, builder, (Parser<Object>)keyParser, (Parser<Object>)valueParser, step);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return RecordParser.parse(input, recon, builder, null, null, 1);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return RecordParser.parse(input, recon, null, null, null, 1);
    }
}

