/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.ChunkExtension;
import swim.http.HttpChunkHeader;
import swim.http.HttpParser;
import swim.util.Builder;

final class HttpChunkHeaderParser
extends Parser<HttpChunkHeader> {
    final HttpParser http;
    final long size;
    final Parser<ChunkExtension> extension;
    final Builder<ChunkExtension, FingerTrieSeq<ChunkExtension>> extensions;
    final int step;

    HttpChunkHeaderParser(HttpParser http, long size, Parser<ChunkExtension> extension, Builder<ChunkExtension, FingerTrieSeq<ChunkExtension>> extensions, int step) {
        this.http = http;
        this.size = size;
        this.extension = extension;
        this.extensions = extensions;
        this.step = step;
    }

    HttpChunkHeaderParser(HttpParser http) {
        this(http, 0L, null, null, 1);
    }

    public Parser<HttpChunkHeader> feed(Input input) {
        return HttpChunkHeaderParser.parse(input, this.http, this.size, this.extension, this.extensions, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static Parser<HttpChunkHeader> parse(Input input, HttpParser http, long size, Parser<ChunkExtension> extension32222, Builder<ChunkExtension, FingerTrieSeq<ChunkExtension>> extensions, int step) {
        void extension32222;
        int c;
        block27: {
            void extension32222;
            c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Base16.isDigit((int)c)) {
                        return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"chunk size", (Input)input));
                    }
                    input = input.step();
                    size = Base16.decodeDigit((int)c);
                    step = 2;
                } else if (input.isDone()) {
                    return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"chunk size", (Input)input));
                }
            }
            if (step == 2) {
                while (input.isCont() && Base16.isDigit((int)(c = input.head()))) {
                    input = input.step();
                    if ((size = size << 4 | (long)Base16.decodeDigit((int)c)) >= 0L) continue;
                    return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.message((String)"chunk size overflow", (Input)input));
                }
                if (!input.isEmpty()) {
                    step = 3;
                }
            }
            while (true) {
                block28: {
                    block29: {
                        if (step != 3) break block28;
                        if (!input.isCont()) break block29;
                        c = input.head();
                        if (c == 59) {
                            step = 4;
                            break block28;
                        } else {
                            step = 5;
                            break block27;
                        }
                    }
                    if (input.isDone()) {
                        return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block27;
                if (extension32222 == null) {
                    Parser<ChunkExtension> extension32222 = http.parseChunkExtension(input);
                } else {
                    void extension32222;
                    Parser extension32222 = extension32222.feed(input);
                }
                if (!extension32222.isDone()) break;
                if (extensions == null) {
                    extensions = FingerTrieSeq.builder();
                }
                extensions.add((Object)((ChunkExtension)extension32222.bind()));
                Object extension32222 = null;
                step = 3;
            }
            if (extension32222.isError()) {
                return extension32222.asError();
            }
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c != 13) {
                    return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                }
                input = input.step();
                step = 6;
            } else if (input.isDone()) {
                return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
            }
        }
        if (step == 6) {
            if (input.isCont()) {
                c = input.head();
                if (c != 10) {
                    return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                }
                input = input.step();
                if (extensions == null) {
                    return HttpChunkHeaderParser.done((Object)http.chunkHeader(size, (FingerTrieSeq<ChunkExtension>)FingerTrieSeq.empty()));
                }
                return HttpChunkHeaderParser.done((Object)http.chunkHeader(size, (FingerTrieSeq<ChunkExtension>)((FingerTrieSeq)extensions.bind())));
            }
            if (input.isDone()) {
                return HttpChunkHeaderParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (input.isError()) {
            return HttpChunkHeaderParser.error((Throwable)input.trap());
        }
        return new HttpChunkHeaderParser(http, size, (Parser<ChunkExtension>)extension32222, (Builder<ChunkExtension, FingerTrieSeq<ChunkExtension>>)extensions, step);
    }

    static Parser<HttpChunkHeader> parse(Input input, HttpParser http) {
        return HttpChunkHeaderParser.parse(input, http, 0L, null, null, 1);
    }
}

