/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpStatus;
import swim.http.HttpVersion;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.util.Murmur3;

public final class HttpResponse<T>
extends HttpMessage<T>
implements Debug {
    final HttpVersion version;
    final HttpStatus status;
    final FingerTrieSeq<HttpHeader> headers;
    final HttpEntity<T> entity;
    private static int hashSeed;

    HttpResponse(HttpVersion version, HttpStatus status, FingerTrieSeq<HttpHeader> headers, HttpEntity<T> entity) {
        this.version = version;
        this.status = status;
        this.headers = headers;
        this.entity = entity;
    }

    HttpResponse(HttpVersion version, HttpStatus status, FingerTrieSeq<HttpHeader> headers) {
        this(version, status, headers, HttpEntity.empty());
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpResponse<T> version(HttpVersion version) {
        return HttpResponse.from(version, this.status, this.headers, this.entity);
    }

    public HttpStatus status() {
        return this.status;
    }

    public HttpResponse<T> status(HttpStatus status) {
        return HttpResponse.from(this.version, status, this.headers, this.entity);
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public HttpResponse<T> headers(FingerTrieSeq<HttpHeader> headers) {
        return HttpResponse.from(this.version, this.status, headers, this.entity);
    }

    @Override
    public HttpResponse<T> headers(HttpHeader ... headers) {
        return this.headers(FingerTrieSeq.of((Object[])headers));
    }

    @Override
    public HttpResponse<T> appendedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended(newHeaders);
        if (oldHeaders != headers) {
            return HttpResponse.from(this.version, this.status, (FingerTrieSeq<HttpHeader>)headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpResponse<T> appendedHeaders(HttpHeader ... newHeaders) {
        return this.appendedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpResponse<T> appendedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended((Object)newHeader);
        if (oldHeaders != headers) {
            return HttpResponse.from(this.version, this.status, (FingerTrieSeq<HttpHeader>)headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpResponse<T> updatedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpResponse.updatedHeaders(oldHeaders, newHeaders);
        if (oldHeaders != headers) {
            return HttpResponse.from(this.version, this.status, headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpResponse<T> updatedHeaders(HttpHeader ... newHeaders) {
        return this.updatedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpResponse<T> updatedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpResponse.updatedHeaders(oldHeaders, newHeader);
        if (oldHeaders != headers) {
            return HttpResponse.from(this.version, this.status, headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpEntity<T> entity() {
        return this.entity;
    }

    @Override
    public <T2> HttpResponse<T2> entity(HttpEntity<T2> entity) {
        return HttpResponse.from(this.version, this.status, this.headers, entity);
    }

    @Override
    public <T2> HttpResponse<T2> content(HttpEntity<T2> entity) {
        FingerTrieSeq<HttpHeader> headers = HttpResponse.updatedHeaders(this.headers, entity.headers());
        return HttpResponse.from(this.version, this.status, headers, entity);
    }

    public HttpResponse<String> body(String content, MediaType mediaType) {
        return this.content(HttpBody.from(content, mediaType));
    }

    public HttpResponse<String> body(String content) {
        return this.content(HttpBody.from(content));
    }

    @Override
    public <T2> Decoder<HttpResponse<T2>> entityDecoder(Decoder<T2> contentDecoder) {
        return super.entityDecoder(contentDecoder);
    }

    @Override
    public Encoder<?, HttpResponse<T>> httpEncoder(HttpWriter http) {
        return super.httpEncoder(http);
    }

    @Override
    public Encoder<?, HttpResponse<T>> httpEncoder() {
        return super.httpEncoder();
    }

    @Override
    public Encoder<?, HttpResponse<T>> encodeHttp(OutputBuffer<?> output, HttpWriter http) {
        return super.encodeHttp(output, http);
    }

    @Override
    public Encoder<?, HttpResponse<T>> encodeHttp(OutputBuffer<?> output) {
        return super.encodeHttp(output);
    }

    public Writer<?, HttpResponse<T>> httpWriter(HttpWriter http) {
        return http.responseWriter(this);
    }

    public Writer<?, HttpResponse<T>> httpWriter() {
        return this.httpWriter(Http.standardWriter());
    }

    public Writer<?, HttpResponse<T>> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeResponse(this, output);
    }

    public Writer<?, HttpResponse<T>> writeHttp(Output<?> output) {
        return this.writeHttp(output, Http.standardWriter());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpResponse) {
            HttpResponse that = (HttpResponse)other;
            return this.version.equals(that.version) && this.status.equals(that.status) && this.headers.equals(that.headers) && this.entity.equals(that.entity);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpResponse.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.version.hashCode()), (int)this.status.hashCode()), (int)this.headers.hashCode()), (int)this.entity.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpResponse").write(46).write("from").write(40).debug((Object)this.version).write(", ").debug((Object)this.status);
        for (HttpHeader header : this.headers) {
            output = output.write(", ").debug((Object)header);
        }
        output = output.write(41);
        if (this.entity.isDefined()) {
            output = output.write(46).write("entity").write(40).debug(this.entity).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpResponse<T> from(HttpVersion version, HttpStatus status, FingerTrieSeq<HttpHeader> headers, HttpEntity<T> entity) {
        return new HttpResponse<T>(version, status, headers, entity);
    }

    public static <T> HttpResponse<T> from(HttpVersion version, HttpStatus status, FingerTrieSeq<HttpHeader> headers) {
        return new HttpResponse<T>(version, status, headers);
    }

    public static <T> HttpResponse<T> from(HttpVersion version, HttpStatus status, HttpHeader ... headers) {
        return new HttpResponse<T>(version, status, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpResponse<T> from(HttpVersion version, HttpStatus status) {
        return new HttpResponse<T>(version, status, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static <T> HttpResponse<T> from(HttpStatus status, FingerTrieSeq<HttpHeader> headers) {
        return new HttpResponse<T>(HttpVersion.HTTP_1_1, status, headers);
    }

    public static <T> HttpResponse<T> from(HttpStatus status, HttpHeader ... headers) {
        return new HttpResponse<T>(HttpVersion.HTTP_1_1, status, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpResponse<T> from(HttpStatus status) {
        return new HttpResponse<T>(HttpVersion.HTTP_1_1, status, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static <T> HttpResponse<T> parseHttp(String string) {
        return Http.standardParser().parseResponseString(string);
    }
}

