/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpException;
import swim.http.HttpWriter;

final class HttpStatusWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final int code;
    final String phrase;
    final Writer<?, ?> part;
    final int step;

    HttpStatusWriter(HttpWriter http, int code, String phrase, Writer<?, ?> part, int step) {
        this.http = http;
        this.code = code;
        this.phrase = phrase;
        this.part = part;
        this.step = step;
    }

    HttpStatusWriter(HttpWriter http, int code, String phrase) {
        this(http, code, phrase, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpStatusWriter.write(output, this.http, this.code, this.phrase, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, int code, String phrase, Writer<?, ?> part, int step) {
        if (step == 1 && output.isCont()) {
            if (code / 1000 != 0) {
                return HttpStatusWriter.error((Throwable)new HttpException("invalid HTTP status code: " + code));
            }
            output = output.write(Base10.encodeDigit((int)(code / 100 % 10)));
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(Base10.encodeDigit((int)(code / 10 % 10)));
            step = 3;
        }
        if (step == 3 && output.isCont()) {
            output = output.write(Base10.encodeDigit((int)(code % 10)));
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(32);
            step = 5;
        }
        if (step == 5) {
            if ((part = part == null ? http.writePhrase(phrase, output) : part.pull(output)).isDone()) {
                return HttpStatusWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return HttpStatusWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HttpStatusWriter.error((Throwable)output.trap());
        }
        return new HttpStatusWriter(http, code, phrase, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, int code, String phrase) {
        return HttpStatusWriter.write(output, http, code, phrase, null, 1);
    }
}

