/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ExpectParser;
import swim.util.Murmur3;

public final class Expect
extends HttpHeader {
    final String value;
    private static int hashSeed;

    Expect(String value) {
        this.value = value;
    }

    @Override
    public boolean isBlank() {
        return this.value.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "expect";
    }

    @Override
    public String name() {
        return "Expect";
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean is100Continue() {
        return "100-continue".equals(this.value);
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writePhrase(this.value, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Expect) {
            Expect that = (Expect)other;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Expect.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.value.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Expect").write(46).write("from").write(40).debug((Object)this.value).write(41);
    }

    public static Expect from(String value) {
        return new Expect(value);
    }

    public static Parser<Expect> parseHttpValue(Input input, HttpParser http) {
        return ExpectParser.parse(input);
    }
}

