/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.OriginParser;
import swim.http.header.OriginWriter;
import swim.uri.Uri;
import swim.util.Builder;
import swim.util.Murmur3;

public final class Origin
extends HttpHeader {
    final FingerTrieSeq<Uri> origins;
    private static int hashSeed;
    private static Origin empty;

    Origin(FingerTrieSeq<Uri> origins) {
        this.origins = origins;
    }

    @Override
    public String lowerCaseName() {
        return "origin";
    }

    @Override
    public String name() {
        return "Origin";
    }

    public FingerTrieSeq<Uri> origins() {
        return this.origins;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        if (this.origins.isEmpty()) {
            return Unicode.writeString((Object)"null", output);
        }
        return OriginWriter.write(output, this.origins.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Origin) {
            Origin that = (Origin)other;
            return this.origins.equals(that.origins);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Origin.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.origins.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Origin").write(46);
        int n = this.origins.size();
        if (n > 0) {
            output = output.write("from").write(40).debug((Object)((Uri)this.origins.head()).toString());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").write(((Uri)this.origins.get(i)).toString());
            }
            output = output.write(41);
        } else {
            output = output.write("empty").write(40).write(41);
        }
    }

    public static Origin empty() {
        if (empty == null) {
            empty = new Origin((FingerTrieSeq<Uri>)FingerTrieSeq.empty());
        }
        return empty;
    }

    public static Origin from(FingerTrieSeq<Uri> origins) {
        if (origins.isEmpty()) {
            return Origin.empty();
        }
        return new Origin(origins);
    }

    public static Origin from(Uri ... origins) {
        if (origins.length == 0) {
            return Origin.empty();
        }
        return new Origin((FingerTrieSeq<Uri>)FingerTrieSeq.of((Object[])origins));
    }

    public static Origin from(String ... originStrings) {
        Builder origins = FingerTrieSeq.builder();
        int n = originStrings.length;
        for (int i = 0; i < n; ++i) {
            origins.add((Object)Uri.parse((String)originStrings[i]));
        }
        return new Origin((FingerTrieSeq<Uri>)((FingerTrieSeq)origins.bind()));
    }

    public static Parser<Origin> parseHttpValue(Input input, HttpParser http) {
        return OriginParser.parse(input);
    }
}

