/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketProtocolParser;
import swim.util.Murmur3;

public final class SecWebSocketProtocol
extends HttpHeader {
    final FingerTrieSeq<String> protocols;
    private static int hashSeed;

    SecWebSocketProtocol(FingerTrieSeq<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public boolean isBlank() {
        return this.protocols.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-protocol";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Protocol";
    }

    public FingerTrieSeq<String> protocols() {
        return this.protocols;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(this.protocols.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketProtocol) {
            SecWebSocketProtocol that = (SecWebSocketProtocol)other;
            return this.protocols.equals(that.protocols);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketProtocol.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.protocols.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("SecWebSocketProtocol").write(46).write("from").write(40);
        int n = this.protocols.size();
        if (n > 0) {
            output.debug(this.protocols.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.protocols.head());
            }
        }
        output = output.write(41);
    }

    public static SecWebSocketProtocol from(FingerTrieSeq<String> protocols) {
        return new SecWebSocketProtocol(protocols);
    }

    public static SecWebSocketProtocol from(String ... protocols) {
        return new SecWebSocketProtocol((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])protocols));
    }

    public static Parser<SecWebSocketProtocol> parseHttpValue(Input input, HttpParser http) {
        return SecWebSocketProtocolParser.parse(input, http);
    }
}

