/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.Product;
import swim.http.header.UserAgentParser;
import swim.http.header.UserAgentWriter;
import swim.util.Builder;
import swim.util.Murmur3;

public final class UserAgent
extends HttpHeader {
    final FingerTrieSeq<Product> products;
    private static int hashSeed;

    UserAgent(FingerTrieSeq<Product> products) {
        this.products = products;
    }

    @Override
    public String lowerCaseName() {
        return "user-agent";
    }

    @Override
    public String name() {
        return "User-Agent";
    }

    public FingerTrieSeq<Product> products() {
        return this.products;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return UserAgentWriter.write(output, http, this.products.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserAgent) {
            UserAgent that = (UserAgent)other;
            return this.products.equals(that.products);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UserAgent.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.products.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("UserAgent").write(46).write("from").write(40);
        int n = this.products.size();
        if (n > 0) {
            output.debug(this.products.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.products.get(i));
            }
        }
        output = output.write(41);
    }

    public static UserAgent from(FingerTrieSeq<Product> products) {
        return new UserAgent(products);
    }

    public static UserAgent from(Product ... products) {
        return new UserAgent((FingerTrieSeq<Product>)FingerTrieSeq.of((Object[])products));
    }

    public static UserAgent from(String ... productStrings) {
        Builder products = FingerTrieSeq.builder();
        int n = productStrings.length;
        for (int i = 0; i < n; ++i) {
            products.add((Object)Product.parse(productStrings[i]));
        }
        return new UserAgent((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind()));
    }

    public static Parser<UserAgent> parseHttpValue(Input input, HttpParser http) {
        return UserAgentParser.parse(input, http);
    }
}

