/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.net.Socket;
import java.net.SocketException;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.TcpSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class TcpSettings
implements Debug {
    protected final boolean keepAlive;
    protected final boolean noDelay;
    protected final int receiveBufferSize;
    protected final int sendBufferSize;
    protected final int readBufferSize;
    protected final int writeBufferSize;
    private static int hashSeed;
    private static TcpSettings standard;
    private static Form<TcpSettings> form;

    public TcpSettings(boolean keepAlive, boolean noDelay, int receiveBufferSize, int sendBufferSize, int readBufferSize, int writeBufferSize) {
        this.keepAlive = keepAlive;
        this.noDelay = noDelay;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
    }

    public final boolean keepAlive() {
        return this.keepAlive;
    }

    public TcpSettings keepAlive(boolean keepAlive) {
        return this.copy(keepAlive, this.noDelay, this.receiveBufferSize, this.sendBufferSize, this.readBufferSize, this.writeBufferSize);
    }

    public final boolean noDelay() {
        return this.noDelay;
    }

    public TcpSettings noDelay(boolean noDelay) {
        return this.copy(this.keepAlive, noDelay, this.receiveBufferSize, this.sendBufferSize, this.readBufferSize, this.writeBufferSize);
    }

    public final int receiveBufferSize() {
        return this.receiveBufferSize;
    }

    public TcpSettings receiveBufferSize(int receiveBufferSize) {
        return this.copy(this.keepAlive, this.noDelay, receiveBufferSize, this.sendBufferSize, this.readBufferSize, this.writeBufferSize);
    }

    public final int sendBufferSize() {
        return this.sendBufferSize;
    }

    public TcpSettings sendBufferSize(int sendBufferSize) {
        return this.copy(this.keepAlive, this.noDelay, this.receiveBufferSize, sendBufferSize, this.readBufferSize, this.writeBufferSize);
    }

    public final int readBufferSize() {
        return this.readBufferSize;
    }

    public TcpSettings readBufferSize(int readBufferSize) {
        return this.copy(this.keepAlive, this.noDelay, this.receiveBufferSize, this.sendBufferSize, readBufferSize, this.writeBufferSize);
    }

    public final int writeBufferSize() {
        return this.writeBufferSize;
    }

    public TcpSettings writeBufferSize(int writeBufferSize) {
        return this.copy(this.keepAlive, this.noDelay, this.receiveBufferSize, this.sendBufferSize, this.readBufferSize, writeBufferSize);
    }

    protected TcpSettings copy(boolean keepAlive, boolean noDelay, int receiveBufferSize, int sendBufferSize, int readBufferSize, int writeBufferSize) {
        return new TcpSettings(keepAlive, noDelay, receiveBufferSize, sendBufferSize, readBufferSize, writeBufferSize);
    }

    public void configure(Socket socket) throws SocketException {
        socket.setKeepAlive(this.keepAlive);
        socket.setTcpNoDelay(this.noDelay);
        if (this.receiveBufferSize != 0) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != 0) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
    }

    public Value toValue() {
        return TcpSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof TcpSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TcpSettings) {
            TcpSettings that = (TcpSettings)other;
            return that.canEqual(this) && this.keepAlive == that.keepAlive && this.noDelay == that.noDelay && this.receiveBufferSize == that.receiveBufferSize && this.sendBufferSize == that.sendBufferSize && this.readBufferSize == that.readBufferSize && this.writeBufferSize == that.writeBufferSize;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TcpSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((boolean)this.keepAlive)), (int)Murmur3.hash((boolean)this.noDelay)), (int)this.receiveBufferSize), (int)this.sendBufferSize), (int)this.readBufferSize), (int)this.writeBufferSize));
    }

    public void debug(Output<?> output) {
        output = output.write("TcpSettings").write(46).write("standard").write(40).write(41).write(46).write("noDelay").write(40).debug((Object)this.noDelay).write(41).write(46).write("keepAlive").write(40).debug((Object)this.keepAlive).write(41).write(46).write("receiveBufferSize").write(40).debug((Object)this.receiveBufferSize).write(41).write(46).write("sendBufferSize").write(40).debug((Object)this.sendBufferSize).write(41).write(46).write("readBufferSize").write(40).debug((Object)this.readBufferSize).write(41).write(46).write("writeBufferSize").write(40).debug((Object)this.writeBufferSize).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static TcpSettings standard() {
        if (standard == null) {
            int writeBufferSize;
            int readBufferSize;
            int sendBufferSize;
            int receiveBufferSize;
            boolean keepAlive = Boolean.parseBoolean(System.getProperty("swim.tcp.keepalive"));
            boolean noDelay = Boolean.parseBoolean(System.getProperty("swim.tcp.nodelay"));
            try {
                receiveBufferSize = Integer.parseInt(System.getProperty("swim.tcp.receive.buffer.size"));
            }
            catch (NumberFormatException error) {
                receiveBufferSize = 0;
            }
            try {
                sendBufferSize = Integer.parseInt(System.getProperty("swim.tcp.send.buffer.size"));
            }
            catch (NumberFormatException error) {
                sendBufferSize = 0;
            }
            try {
                readBufferSize = Integer.parseInt(System.getProperty("swim.tcp.read.buffer.size"));
            }
            catch (NumberFormatException error) {
                readBufferSize = 4096;
            }
            try {
                writeBufferSize = Integer.parseInt(System.getProperty("swim.tcp.write.buffer.size"));
            }
            catch (NumberFormatException error) {
                writeBufferSize = 4096;
            }
            standard = new TcpSettings(keepAlive, noDelay, receiveBufferSize, sendBufferSize, readBufferSize, writeBufferSize);
        }
        return standard;
    }

    @Kind
    public static Form<TcpSettings> form() {
        if (form == null) {
            form = new TcpSettingsForm();
        }
        return form;
    }
}

