/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.io.TcpSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class TcpSettingsForm
extends Form<TcpSettings> {
    TcpSettingsForm() {
    }

    public String tag() {
        return "tcp";
    }

    public TcpSettings unit() {
        return TcpSettings.standard();
    }

    public Class<?> type() {
        return TcpSettings.class;
    }

    public Item mold(TcpSettings settings) {
        if (settings != null) {
            TcpSettings standard = TcpSettings.standard();
            Record record = Record.create((int)7).attr(this.tag());
            if (settings.keepAlive != standard.keepAlive) {
                record.slot("keepAlive", true);
            }
            if (settings.noDelay != standard.noDelay) {
                record.slot("noDelay", true);
            }
            if (settings.receiveBufferSize != standard.receiveBufferSize) {
                record.slot("receiveBufferSize", settings.receiveBufferSize);
            }
            if (settings.sendBufferSize != standard.sendBufferSize) {
                record.slot("sendBufferSize", settings.sendBufferSize);
            }
            if (settings.readBufferSize != standard.readBufferSize) {
                record.slot("readBufferSize", settings.readBufferSize);
            }
            if (settings.writeBufferSize != standard.writeBufferSize) {
                record.slot("writeBufferSize", settings.writeBufferSize);
            }
            return record;
        }
        return Item.extant();
    }

    public TcpSettings cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            TcpSettings standard = TcpSettings.standard();
            boolean keepAlive = value.get("keepAlive").booleanValue(standard.keepAlive);
            boolean noDelay = value.get("noDelay").booleanValue(standard.noDelay);
            int receiveBufferSize = value.get("receiveBufferSize").intValue(standard.receiveBufferSize);
            int sendBufferSize = value.get("sendBufferSize").intValue(standard.sendBufferSize);
            int readBufferSize = value.get("readBufferSize").intValue(standard.readBufferSize);
            int writeBufferSize = value.get("writeBufferSize").intValue(standard.writeBufferSize);
            return new TcpSettings(keepAlive, noDelay, receiveBufferSize, sendBufferSize, readBufferSize, writeBufferSize);
        }
        return null;
    }
}

