/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.io.TransportSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class TransportSettingsForm
extends Form<TransportSettings> {
    TransportSettingsForm() {
    }

    public String tag() {
        return "transport";
    }

    public TransportSettings unit() {
        return TransportSettings.standard();
    }

    public Class<?> type() {
        return TransportSettings.class;
    }

    public Item mold(TransportSettings settings) {
        if (settings != null) {
            TransportSettings standard = TransportSettings.standard();
            Record record = Record.create((int)4).attr(this.tag());
            if (settings.backlog != standard.backlog) {
                record.slot("backlog", settings.backlog);
            }
            if (settings.idleInterval != standard.idleInterval) {
                record.slot("idleInterval", settings.idleInterval);
            }
            if (settings.idleTimeout != standard.idleTimeout) {
                record.slot("idleTimeout", settings.idleTimeout);
            }
            return record;
        }
        return Item.extant();
    }

    public TransportSettings cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            TransportSettings standard = TransportSettings.standard();
            int backlog = value.get("backlog").intValue(standard.backlog);
            long idleInterval = value.get("idleInterval").longValue(standard.idleInterval);
            long idleTimeout = value.get("idleTimeout").longValue(standard.idleTimeout);
            return new TransportSettings(backlog, idleInterval, idleTimeout);
        }
        return null;
    }
}

