/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public final class MqttConnStatus
implements Debug {
    public final int code;
    private static int hashSeed;
    public static final MqttConnStatus ACCEPTED;
    public static final MqttConnStatus UNACCEPTABLE_PROTOCOL_VERSION;
    public static final MqttConnStatus IDENTIFIER_REJECTED;
    public static final MqttConnStatus SERVER_UNAVAILABLE;
    public static final MqttConnStatus BAD_USERNAME_OR_PASSWORD;
    public static final MqttConnStatus NOT_AUTHORIZED;

    MqttConnStatus(int code) {
        this.code = code;
    }

    public boolean isAccepted() {
        return this.code == 0;
    }

    public boolean isRefused() {
        return this.code != 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttConnStatus) {
            MqttConnStatus that = (MqttConnStatus)other;
            return this.code == that.code;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttConnStatus.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.code));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttConnStatus").write(46);
        switch (this.code) {
            case 0: {
                output.write("ACCEPTED");
                break;
            }
            case 1: {
                output.write("UNACCEPTABLE_PROTOCOL_VERSION");
                break;
            }
            case 2: {
                output.write("IDENTIFIER_REJECTED");
                break;
            }
            case 3: {
                output.write("SERVER_UNAVAILABLE");
                break;
            }
            case 4: {
                output.write("BAD_USERNAME_OR_PASSWORD");
                break;
            }
            case 5: {
                output.write("NOT_AUTHORIZED");
                break;
            }
            default: {
                output.write("from").write(40).debug((Object)this.code).write(41);
            }
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttConnStatus from(int code) {
        switch (code) {
            case 0: {
                return ACCEPTED;
            }
            case 1: {
                return UNACCEPTABLE_PROTOCOL_VERSION;
            }
            case 2: {
                return IDENTIFIER_REJECTED;
            }
            case 3: {
                return SERVER_UNAVAILABLE;
            }
            case 4: {
                return BAD_USERNAME_OR_PASSWORD;
            }
            case 5: {
                return NOT_AUTHORIZED;
            }
        }
        return new MqttConnStatus(code);
    }

    static {
        ACCEPTED = new MqttConnStatus(0);
        UNACCEPTABLE_PROTOCOL_VERSION = new MqttConnStatus(1);
        IDENTIFIER_REJECTED = new MqttConnStatus(2);
        SERVER_UNAVAILABLE = new MqttConnStatus(3);
        BAD_USERNAME_OR_PASSWORD = new MqttConnStatus(4);
        NOT_AUTHORIZED = new MqttConnStatus(5);
    }
}

