/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttException;
import swim.structure.Data;

final class MqttDataEncoder
extends Encoder<Data, Data> {
    final Data data;
    final Encoder<?, ?> encoder;
    final int step;

    MqttDataEncoder(Data data, Encoder<?, ?> encoder, int step) {
        this.data = data;
        this.encoder = encoder;
        this.step = step;
    }

    MqttDataEncoder(Data data) {
        this(data, null, 1);
    }

    public Encoder<Data, Data> feed(Data data) {
        return new MqttDataEncoder(data, null, 1);
    }

    public Encoder<Data, Data> pull(OutputBuffer<?> output) {
        return MqttDataEncoder.encode(output, this.data, this.encoder, this.step);
    }

    static int sizeOf(Data data) {
        return 2 + data.size();
    }

    static Encoder<Data, Data> encode(OutputBuffer<?> output, Data data, Encoder<?, ?> encoder, int step) {
        if (step == 1 && output.isCont()) {
            if (data.size() > 65535) {
                return MqttDataEncoder.error((Throwable)new MqttException("data too long (" + data.size() + " bytes)"));
            }
            output = output.write(data.size() >>> 8);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(data.size());
            step = 3;
        }
        if (step == 3) {
            if ((encoder = encoder == null ? data.write((Output)output) : encoder.pull(output)).isDone()) {
                return MqttDataEncoder.done((Object)data);
            }
            if (encoder.isError()) {
                return encoder.asError();
            }
        }
        if (output.isDone()) {
            return MqttDataEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttDataEncoder.error((Throwable)output.trap());
        }
        return new MqttDataEncoder(data, (Encoder<?, ?>)encoder, step);
    }

    static Encoder<Data, Data> encode(OutputBuffer<?> output, Data data) {
        return MqttDataEncoder.encode(output, data, null, 1);
    }
}

