/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.DownlinkRelay;
import swim.runtime.downlink.EventDownlinkModel;
import swim.runtime.downlink.EventDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.warp.EventMessage;

final class EventDownlinkRelayOnEvent
extends DownlinkRelay<EventDownlinkModel, EventDownlinkView<?>> {
    final EventMessage message;
    Form<Object> valueForm;
    Object object;

    EventDownlinkRelayOnEvent(EventDownlinkModel model, EventMessage message) {
        super(model, 3);
        this.message = message;
    }

    @Override
    protected boolean runPhase(EventDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.object = valueForm.cast((Item)this.message.body());
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkOnEvent(this.object);
            }
            return view.dispatchOnEvent(this.object, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((EventDownlinkModel)this.model).cueDown();
    }
}

