/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.http;

import swim.api.http.HttpUplink;
import swim.codec.Decoder;
import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.runtime.HttpBinding;
import swim.runtime.LaneModel;
import swim.runtime.LaneView;
import swim.runtime.LinkBinding;
import swim.runtime.PushRequest;
import swim.runtime.http.HttpLaneRelayDidRequest;
import swim.runtime.http.HttpLaneRelayDidRespond;
import swim.runtime.http.HttpLaneRelayDoRespond;
import swim.runtime.http.HttpLaneRelayWillRequest;
import swim.runtime.http.HttpLaneRelayWillRespond;
import swim.runtime.http.HttpLaneView;
import swim.runtime.http.HttpUplinkModem;
import swim.warp.CommandMessage;

public abstract class HttpLaneModel<View extends HttpLaneView<?>, U extends HttpUplinkModem>
extends LaneModel<View, U> {
    @Override
    public String laneType() {
        return "http";
    }

    @Override
    protected U createUplink(LinkBinding link) {
        if (link instanceof HttpBinding) {
            return this.createHttpUplink((HttpBinding)link);
        }
        return null;
    }

    protected abstract U createHttpUplink(HttpBinding var1);

    @Override
    public void pushUp(PushRequest pushRequest) {
        pushRequest.didDecline();
    }

    @Override
    public void pushUpCommand(CommandMessage message) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void didOpenLaneView(View view) {
    }

    protected Decoder<Object> decodeRequestDefault(U uplink, HttpRequest<?> request) {
        return request.contentDecoder();
    }

    protected HttpResponse<?> doRespondDefault(U uplink, HttpRequest<?> request) {
        return HttpResponse.from((HttpStatus)HttpStatus.NOT_FOUND).entity((HttpEntity)HttpBody.empty());
    }

    protected Decoder<Object> decodeRequest(U uplink, HttpRequest<?> request) {
        Object views = this.views;
        Decoder<Object> decoder = null;
        if (views instanceof HttpLaneView) {
            HttpLaneView view = (HttpLaneView)views;
            decoder = view.dispatchDecodeRequest((HttpUplink)uplink, request);
            if (decoder == null) {
                decoder = view.laneDecodeRequest((HttpUplink)uplink, request);
            }
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                HttpLaneView view = (HttpLaneView)viewArray[i];
                decoder = view.dispatchDecodeRequest((HttpUplink)uplink, request);
                if (decoder == null) {
                    decoder = view.laneDecodeRequest((HttpUplink)uplink, request);
                }
                if (decoder != null) break;
            }
        }
        if (decoder == null) {
            decoder = this.decodeRequestDefault(uplink, request);
        }
        return decoder;
    }

    protected void willRequest(U uplink, HttpRequest<?> request) {
        new HttpLaneRelayWillRequest(this, (HttpUplinkModem)uplink, request).run();
    }

    protected void didRequest(U uplink, HttpRequest<Object> request) {
        new HttpLaneRelayDidRequest(this, (HttpUplinkModem)uplink, request).run();
    }

    protected void doRespond(U uplink, HttpRequest<Object> request) {
        new HttpLaneRelayDoRespond(this, uplink, request).run();
    }

    protected void willRespond(U uplink, HttpResponse<?> response) {
        new HttpLaneRelayWillRespond(this, (HttpUplinkModem)uplink, response).run();
    }

    protected void didRespond(U uplink, HttpResponse<?> response) {
        new HttpLaneRelayDidRespond(this, (HttpUplinkModem)uplink, response).run();
    }
}

