/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.api.Lane;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.data.MapData;
import swim.api.lane.MapLane;
import swim.api.warp.function.DidCommand;
import swim.api.warp.function.DidEnter;
import swim.api.warp.function.DidLeave;
import swim.api.warp.function.DidUplink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillEnter;
import swim.api.warp.function.WillLeave;
import swim.api.warp.function.WillUplink;
import swim.collections.HashTrieMap;
import swim.concurrent.Conts;
import swim.observable.function.DidClear;
import swim.observable.function.DidDrop;
import swim.observable.function.DidRemoveKey;
import swim.observable.function.DidTake;
import swim.observable.function.DidUpdateKey;
import swim.observable.function.WillClear;
import swim.observable.function.WillDrop;
import swim.observable.function.WillRemoveKey;
import swim.observable.function.WillTake;
import swim.observable.function.WillUpdateKey;
import swim.runtime.lane.MapLaneModel;
import swim.runtime.warp.WarpLaneView;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.structure.Form;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class MapLaneView<K, V>
extends WarpLaneView
implements MapLane<K, V> {
    protected final AgentContext agentContext;
    protected Form<K> keyForm;
    protected Form<V> valueForm;
    protected int flags;
    protected MapLaneModel laneBinding;
    protected MapData<K, V> dataView;
    protected MapOutlet<K, V, ? extends Map<K, V>> input;
    protected HashTrieMap<K, KeyEffect> effects;
    protected HashTrieMap<K, KeyOutlet<K, V>> outlets;
    protected Inlet<? super MapLane<K, V>>[] outputs;
    protected int version;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    MapLaneView(AgentContext agentContext, Form<K> keyForm, Form<V> valueForm, int flags, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
        this.flags = flags;
        this.input = null;
        this.effects = HashTrieMap.empty();
        this.outlets = HashTrieMap.empty();
        this.outputs = null;
        this.version = -1;
    }

    public MapLaneView(AgentContext agentContext, Form<K> keyForm, Form<V> valueForm) {
        this(agentContext, keyForm, valueForm, 0, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public MapLaneModel laneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(MapLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public MapLaneModel createLaneBinding() {
        return new MapLaneModel(this.flags);
    }

    public final Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> MapLaneView<K2, V> keyForm(Form<K2> keyForm) {
        return new MapLaneView<K2, V>(this.agentContext, keyForm, this.valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <K2> MapLaneView<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public void setKeyForm(Form<K> keyForm) {
        this.keyForm = keyForm;
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> MapLaneView<K, V2> valueForm(Form<V2> valueForm) {
        return new MapLaneView<K, V2>(this.agentContext, this.keyForm, valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <V2> MapLaneView<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public MapLaneView<K, V> isResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        MapLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isResident(isResident);
        }
        return this;
    }

    void didSetResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public MapLaneView<K, V> isTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        MapLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isTransient(isTransient);
        }
        return this;
    }

    void didSetTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    protected void willLoad() {
        this.dataView = this.laneBinding.data.keyForm(this.keyForm).valueForm(this.valueForm);
        super.willLoad();
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public MapLaneView<K, V> observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public MapLaneView<K, V> unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public MapLaneView<K, V> willUpdate(WillUpdateKey<K, V> willUpdate) {
        return this.observe(willUpdate);
    }

    public MapLaneView<K, V> didUpdate(DidUpdateKey<K, V> didUpdate) {
        return this.observe(didUpdate);
    }

    public MapLaneView<K, V> willRemove(WillRemoveKey<K> willRemove) {
        return this.observe(willRemove);
    }

    public MapLaneView<K, V> didRemove(DidRemoveKey<K, V> didRemove) {
        return this.observe(didRemove);
    }

    public MapLaneView<K, V> willDrop(WillDrop willDrop) {
        return this.observe(willDrop);
    }

    public MapLaneView<K, V> didDrop(DidDrop didDrop) {
        return this.observe(didDrop);
    }

    public MapLaneView<K, V> willTake(WillTake willTake) {
        return this.observe(willTake);
    }

    public MapLaneView<K, V> didTake(DidTake didTake) {
        return this.observe(didTake);
    }

    public MapLaneView<K, V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public MapLaneView<K, V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public MapLaneView<K, V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public MapLaneView<K, V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public MapLaneView<K, V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public MapLaneView<K, V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public MapLaneView<K, V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public MapLaneView<K, V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public MapLaneView<K, V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public MapLaneView<K, V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillUpdate(Link link, K key, V newValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUpdateKey) {
                if (((WillUpdateKey)observers).isPreemptive() == preemptive) {
                    try {
                        newValue = ((WillUpdateKey)observers).willUpdate(key, newValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUpdateKey)) continue;
                    if (((WillUpdateKey)observer).isPreemptive() == preemptive) {
                        try {
                            newValue = ((WillUpdateKey)observer).willUpdate(key, newValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUpdate(Link link, K key, V newValue, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUpdateKey) {
                if (((DidUpdateKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUpdateKey)observers).didUpdate(key, newValue, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUpdateKey)) continue;
                    if (((DidUpdateKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUpdateKey)observer).didUpdate(key, newValue, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillRemove(Link link, K key, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillRemoveKey) {
                if (((WillRemoveKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillRemoveKey)observers).willRemove(key);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillRemoveKey)) continue;
                    if (((WillRemoveKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillRemoveKey)observer).willRemove(key);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidRemove(Link link, K key, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidRemoveKey) {
                if (((DidRemoveKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidRemoveKey)observers).didRemove(key, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidRemoveKey)) continue;
                    if (((DidRemoveKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidRemoveKey)observer).didRemove(key, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillDrop(Link link, int lower, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillDrop) {
                if (((WillDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillDrop)observers).willDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillDrop)) continue;
                    if (((WillDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillDrop)observer).willDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidDrop(Link link, int lower, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidDrop) {
                if (((DidDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidDrop)observers).didDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidDrop)) continue;
                    if (((DidDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidDrop)observer).didDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillTake(Link link, int upper, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillTake) {
                if (((WillTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillTake)observers).willTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillTake)) continue;
                    if (((WillTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillTake)observer).willTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidTake(Link link, int upper, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidTake) {
                if (((DidTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidTake)observers).didTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidTake)) continue;
                    if (((DidTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidTake)observer).didTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillClear) {
                if (((WillClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillClear)observers).willClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillClear)) continue;
                    if (((WillClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillClear)observer).willClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidClear) {
                if (((DidClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidClear)observers).didClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidClear)) continue;
                    if (((DidClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidClear)observer).didClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public V laneWillUpdate(K key, V newValue) {
        return newValue;
    }

    public void laneDidUpdate(K key, V newValue, V oldValue) {
        this.invalidateInputKey(key, KeyEffect.UPDATE);
        this.reconcileInputKey(key, 0);
    }

    public void laneWillRemove(K key) {
    }

    public void laneDidRemove(K key, V oldValue) {
        this.invalidateInputKey(key, KeyEffect.REMOVE);
        this.reconcileInputKey(key, 0);
    }

    public void laneWillDrop(int lower) {
    }

    public void laneDidDrop(int lower) {
    }

    public void laneWillTake(int upper) {
    }

    public void laneDidTake(int upper) {
    }

    public void laneWillClear() {
    }

    public void laneDidClear() {
    }

    public boolean isEmpty() {
        return this.dataView.isEmpty();
    }

    public int size() {
        return this.dataView.size();
    }

    public boolean containsKey(Object key) {
        return this.dataView.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.dataView.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.dataView.indexOf(key);
    }

    public V get(Object key) {
        return (V)this.dataView.get(key);
    }

    public Map.Entry<K, V> getEntry(Object key) {
        return this.dataView.getEntry(key);
    }

    public Map.Entry<K, V> getIndex(int index) {
        return this.dataView.getIndex(index);
    }

    public Map.Entry<K, V> firstEntry() {
        return this.dataView.firstEntry();
    }

    public K firstKey() {
        return (K)this.dataView.firstKey();
    }

    public V firstValue() {
        return (V)this.dataView.firstValue();
    }

    public Map.Entry<K, V> lastEntry() {
        return this.dataView.lastEntry();
    }

    public K lastKey() {
        return (K)this.dataView.lastKey();
    }

    public V lastValue() {
        return (V)this.dataView.lastValue();
    }

    public Map.Entry<K, V> nextEntry(K key) {
        return this.dataView.nextEntry(key);
    }

    public K nextKey(K key) {
        return (K)this.dataView.nextKey(key);
    }

    public V nextValue(K key) {
        return (V)this.dataView.nextValue(key);
    }

    public Map.Entry<K, V> previousEntry(K key) {
        return this.dataView.previousEntry(key);
    }

    public K previousKey(K key) {
        return (K)this.dataView.previousKey(key);
    }

    public V previousValue(K key) {
        return (V)this.dataView.previousValue(key);
    }

    public V put(K key, V value) {
        return this.laneBinding.put(this, key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.laneBinding.put(this, entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(key)) {
            return this.laneBinding.remove(this, key);
        }
        return (V)this.valueForm.unit();
    }

    public void drop(int lower) {
        this.laneBinding.drop(this, lower);
    }

    public void take(int upper) {
        this.laneBinding.take(this, upper);
    }

    public void clear() {
        this.laneBinding.clear(this);
    }

    public OrderedMap<K, V> headMap(K toKey) {
        return this.dataView.headMap(toKey);
    }

    public OrderedMap<K, V> tailMap(K fromKey) {
        return this.dataView.tailMap(fromKey);
    }

    public OrderedMap<K, V> subMap(K fromKey, K toKey) {
        return this.dataView.subMap(fromKey, toKey);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.dataView.entrySet();
    }

    public Set<K> keySet() {
        return this.dataView.keySet();
    }

    public Collection<V> values() {
        return this.dataView.values();
    }

    public OrderedMapCursor<K, V> iterator() {
        return this.dataView.iterator();
    }

    public Cursor<K> keyIterator() {
        return this.dataView.keyIterator();
    }

    public Cursor<V> valueIterator() {
        return this.dataView.valueIterator();
    }

    public OrderedMap<K, V> snapshot() {
        return this.dataView.snapshot();
    }

    public Comparator<? super K> comparator() {
        return this.dataView.comparator();
    }

    public MapLane<K, V> get() {
        return this;
    }

    public MapOutlet<K, V, ? extends Map<K, V>> input() {
        return this.input;
    }

    public void bindInput(Outlet<? extends Map<K, V>> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<K, V, ? extends Map<K, V>> input) {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput((Inlet)this);
        }
    }

    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = null;
    }

    public void disconnectInputs() {
        MapOutlet<K, V, ? extends Map<K, V>> input = this.input;
        if (input != null) {
            input.unbindOutput((Inlet)this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    public Outlet<V> outlet(K key) {
        KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
        if (outlet == null) {
            outlet = new KeyOutlet((MapOutlet)this, key);
            this.outlets = this.outlets.updated(key, (Object)outlet);
        }
        return outlet;
    }

    public Iterator<Inlet<? super MapLane<K, V>>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    public void bindOutput(Inlet<? super MapLane<K, V>> output) {
        Inlet<? super MapLane<K, V>>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    public void unbindOutput(Inlet<? super MapLane<K, V>> output) {
        Inlet<? super MapLane<K, V>>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    public void unbindOutputs() {
        Inlet<? super MapLane<K, V>>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<? super MapLane<K, V>> output : outputs) {
                output.unbindInput();
            }
        }
    }

    public void disconnectOutputs() {
        Inlet<? super MapLane<K, V>>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.disconnectOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<? super MapLane<K, V>> output : outputs) {
                output.unbindInput();
                output.disconnectOutputs();
            }
        }
    }

    public void invalidateOutputKey(K key, KeyEffect effect) {
        this.invalidateKey(key, effect);
    }

    public void invalidateInputKey(K key, KeyEffect effect) {
        this.invalidateKey(key, effect);
    }

    public void invalidateKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willInvalidateKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super MapLane<K, V>> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).invalidateOutputKey(key, effect);
                    continue;
                }
                output.invalidateOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.invalidateInput();
            }
            this.didInvalidateKey(key, effect);
        }
    }

    public void invalidateOutput() {
        this.invalidate();
    }

    public void invalidateInput() {
        this.invalidate();
    }

    public void invalidate() {
        if (this.version >= 0) {
            this.willInvalidate();
            this.version = -1;
            this.onInvalidate();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).invalidateInput();
            }
            this.didInvalidate();
        }
    }

    public void reconcileOutputKey(K key, int version) {
        this.reconcileKey(key, version);
    }

    public void reconcileInputKey(K key, int version) {
        this.reconcileKey(key, version);
    }

    public void reconcileKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)(oldEffects = this.effects).get(key)) != null) {
            int n;
            this.willReconcileKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            if (this.input != null) {
                this.input.reconcileInputKey(key, version);
            }
            this.onReconcileKey(key, effect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super MapLane<K, V>> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).reconcileOutputKey(key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.reconcileInput(version);
            }
            this.didReconcileKey(key, effect, version);
        }
    }

    public void reconcileOutput(int version) {
        this.reconcile(version);
    }

    public void reconcileInput(int version) {
        this.reconcile(version);
    }

    public void reconcile(int version) {
        if (this.version < 0) {
            int n;
            this.willReconcile(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.reconcileKey(keys.next(), version);
            }
            this.version = version;
            this.onReconcile(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            this.didReconcile(version);
        }
    }

    protected void willInvalidateKey(K key, KeyEffect effect) {
    }

    protected void onInvalidateKey(K key, KeyEffect effect) {
    }

    protected void didInvalidateKey(K key, KeyEffect effect) {
    }

    protected void willInvalidate() {
    }

    protected void onInvalidate() {
    }

    protected void didInvalidate() {
    }

    protected void willUpdate(int version) {
    }

    protected void didUpdate(int version) {
    }

    protected void willReconcileKey(K key, KeyEffect effect, int version) {
    }

    protected void onReconcileKey(K key, KeyEffect effect, int version) {
        if (effect == KeyEffect.UPDATE) {
            if (this.input != null) {
                Object value = this.input.get(key);
                if (value != null) {
                    this.put(key, value);
                } else {
                    this.remove(key);
                }
            }
        } else if (effect == KeyEffect.REMOVE && this.containsKey(key)) {
            this.remove(key);
        }
    }

    protected void didReconcileKey(K key, KeyEffect effect, int version) {
    }

    protected void willReconcile(int version) {
    }

    protected void onReconcile(int version) {
    }

    protected void didReconcile(int version) {
    }
}

