/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.data.ValueData;
import swim.runtime.LaneView;
import swim.runtime.WarpBinding;
import swim.runtime.lane.ValueLaneRelaySet;
import swim.runtime.lane.ValueLaneUplink;
import swim.runtime.lane.ValueLaneView;
import swim.runtime.warp.WarpLaneModel;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class ValueLaneModel
extends WarpLaneModel<ValueLaneView<?>, ValueLaneUplink> {
    protected int flags;
    protected ValueData<Value> data;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    ValueLaneModel(int flags) {
        this.flags = flags;
    }

    public ValueLaneModel() {
        this(0);
    }

    @Override
    public String laneType() {
        return "value";
    }

    @Override
    protected ValueLaneUplink createWarpUplink(WarpBinding link) {
        return new ValueLaneUplink(this, link);
    }

    @Override
    protected void didOpenLaneView(ValueLaneView<?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        new ValueLaneRelaySet(this, message, message.body()).run();
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ValueLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            for (LaneView aViewArray : (LaneView[])views) {
                ((ValueLaneView)aViewArray).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ValueLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public Value get() {
        return (Value)this.data.get();
    }

    public <V> V set(ValueLaneView<V> view, V newObject) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ValueLaneRelaySet relay = new ValueLaneRelaySet(this, this.stage(), newValue);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    protected void openStore() {
        this.data = this.laneContext.store().valueData(this.laneUri().toString()).isTransient(this.isTransient()).isResident(this.isResident());
    }

    @Override
    protected void willLoad() {
        this.openStore();
        super.willLoad();
    }
}

