/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.function.DidClose;
import swim.api.warp.WarpUplink;
import swim.api.warp.function.OnCommandMessage;
import swim.api.warp.function.OnEventMessage;
import swim.api.warp.function.OnLinkRequest;
import swim.api.warp.function.OnLinkedResponse;
import swim.api.warp.function.OnSyncRequest;
import swim.api.warp.function.OnSyncedResponse;
import swim.api.warp.function.OnUnlinkRequest;
import swim.api.warp.function.OnUnlinkedResponse;
import swim.concurrent.Conts;
import swim.runtime.AbstractUplinkContext;
import swim.runtime.LinkKeys;
import swim.runtime.WarpBinding;
import swim.runtime.WarpContext;
import swim.runtime.warp.WarpUplinkModemOnCommand;
import swim.runtime.warp.WarpUplinkModemOnLink;
import swim.runtime.warp.WarpUplinkModemOnSync;
import swim.runtime.warp.WarpUplinkModemOnUnlink;
import swim.runtime.warp.WarpUplinkModemPullDown;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class WarpUplinkModem
extends AbstractUplinkContext
implements WarpContext,
WarpUplink {
    protected final WarpBinding linkBinding;
    protected final Value linkKey;
    protected volatile int status;
    static final int LINKED = 1;
    static final int LINKING = 2;
    static final int SYNCING = 4;
    static final int UNLINKING = 8;
    static final int CUED_DOWN = 16;
    static final int FEEDING_DOWN = 32;
    static final int FEEDING_UP = 64;
    static final int PULLING_UP = 128;
    static final AtomicIntegerFieldUpdater<WarpUplinkModem> STATUS = AtomicIntegerFieldUpdater.newUpdater(WarpUplinkModem.class, "status");

    protected WarpUplinkModem(WarpBinding linkBinding, Value linkKey) {
        this.linkBinding = linkBinding;
        this.linkKey = linkKey.commit();
    }

    protected WarpUplinkModem(WarpBinding linkBinding) {
        this(linkBinding, LinkKeys.generateLinkKey());
    }

    @Override
    public final WarpBinding linkWrapper() {
        return this.linkBinding.linkWrapper();
    }

    @Override
    public final WarpBinding linkBinding() {
        return this.linkBinding;
    }

    @Override
    public final Uri hostUri() {
        return this.linkBinding.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.linkBinding.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.linkBinding.laneUri();
    }

    @Override
    public final Value linkKey() {
        return this.linkKey;
    }

    public final float prio() {
        return this.linkBinding.prio();
    }

    public final float rate() {
        return this.linkBinding.rate();
    }

    public final Value body() {
        return this.linkBinding.body();
    }

    @Override
    public WarpUplinkModem observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public WarpUplinkModem unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public WarpUplinkModem onEvent(OnEventMessage onEvent) {
        this.observe(onEvent);
        return this;
    }

    public WarpUplinkModem onCommand(OnCommandMessage onCommand) {
        this.observe(onCommand);
        return this;
    }

    public WarpUplinkModem onLink(OnLinkRequest onLink) {
        this.observe(onLink);
        return this;
    }

    public WarpUplinkModem onLinked(OnLinkedResponse onLinked) {
        this.observe(onLinked);
        return this;
    }

    public WarpUplinkModem onSync(OnSyncRequest onSync) {
        this.observe(onSync);
        return this;
    }

    public WarpUplinkModem onSynced(OnSyncedResponse onSynced) {
        this.observe(onSynced);
        return this;
    }

    public WarpUplinkModem onUnlink(OnUnlinkRequest onUnlink) {
        this.observe(onUnlink);
        return this;
    }

    public WarpUplinkModem onUnlinked(OnUnlinkedResponse onUnlinked) {
        this.observe(onUnlinked);
        return this;
    }

    public WarpUplinkModem didClose(DidClose didClose) {
        this.observe(didClose);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnEvent(EventMessage message) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnEventMessage) {
                    try {
                        ((OnEventMessage)observers).onEvent(message);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnEventMessage)) continue;
                        try {
                            ((OnEventMessage)observer).onEvent(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnCommand(CommandMessage message, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnCommandMessage)) break block12;
                        if (((OnCommandMessage)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnCommandMessage)observers).onCommand(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnCommandMessage)) continue;
                        if (((OnCommandMessage)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnCommandMessage)observer).onCommand(message);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnLink(LinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnLinkRequest)) break block12;
                        if (((OnLinkRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnLinkRequest)observers).onLink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLinkRequest)) continue;
                        if (((OnLinkRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnLinkRequest)observer).onLink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnLinked(LinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnLinkedResponse) {
                    try {
                        ((OnLinkedResponse)observers).onLinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLinkedResponse)) continue;
                        try {
                            ((OnLinkedResponse)observer).onLinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnSync(SyncRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnSyncRequest)) break block12;
                        if (((OnSyncRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnSyncRequest)observers).onSync(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSyncRequest)) continue;
                        if (((OnSyncRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnSyncRequest)observer).onSync(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnSynced(SyncedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnSyncedResponse) {
                    try {
                        ((OnSyncedResponse)observers).onSynced(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSyncedResponse)) continue;
                        try {
                            ((OnSyncedResponse)observer).onSynced(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnUnlink(UnlinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnUnlinkRequest)) break block12;
                        if (((OnUnlinkRequest)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnUnlinkRequest)observers).onUnlink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlinkRequest)) continue;
                        if (((OnUnlinkRequest)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnUnlinkRequest)observer).onUnlink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnUnlinked(UnlinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnUnlinkedResponse) {
                    try {
                        ((OnUnlinkedResponse)observers).onUnlinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlinkedResponse)) continue;
                        try {
                            ((OnUnlinkedResponse)observer).onUnlinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchDidClose() {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof DidClose) {
                    try {
                        ((DidClose)observers).didClose();
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClose)) continue;
                        try {
                            ((DidClose)observer).didClose();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    protected boolean downQueueIsEmpty() {
        return true;
    }

    protected void queueDown(Value body) {
        throw new UnsupportedOperationException();
    }

    protected Value nextDownQueue() {
        return null;
    }

    protected EventMessage nextDownQueueEvent() {
        Value body = this.nextDownQueue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    protected Value nextDownCue() {
        return null;
    }

    protected EventMessage nextDownCueEvent() {
        Value body = this.nextDownCue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    public void sendDown(Value body) {
        int newStatus;
        int oldStatus;
        this.queueDown(body);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x20) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkBinding.feedDown();
        }
    }

    public void cueDown() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 1) != 0 ? oldStatus | 0x20 | 0x10 : oldStatus | 0x10) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) != (newStatus & 0x20)) {
            this.linkBinding.feedDown();
        }
    }

    @Override
    public void pullDown() {
        this.stage().execute((Runnable)new WarpUplinkModemPullDown(this));
    }

    protected void runPullDown() {
        try {
            this.pullDownEnvelope();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void pullDownEnvelope() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 8) != 0) {
                newStatus = oldStatus & 0xFFFFFFF7;
                continue;
            }
            if ((oldStatus & 2) != 0) {
                newStatus = oldStatus & 0xFFFFFFFD;
                continue;
            }
            newStatus = oldStatus;
            break;
        } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 8) != (newStatus & 8)) {
            UnlinkedResponse response = this.unlinkedResponse();
            this.pullDownUnlinked(response);
            this.linkBinding.pushDown((Envelope)response);
        } else if ((oldStatus & 2) != (newStatus & 2)) {
            LinkedResponse response = this.linkedResponse();
            this.pullDownLinked(response);
            this.linkBinding.pushDown((Envelope)response);
            if ((newStatus & 4) != 0) {
                this.linkBinding.feedDown();
            } else {
                do {
                    if (((oldStatus = this.status) & 0x10) != 0 || !this.downQueueIsEmpty()) {
                        newStatus = oldStatus;
                        break;
                    }
                    newStatus = oldStatus & 0xFFFFFFDF;
                } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
                if (oldStatus == newStatus) {
                    this.linkBinding.feedDown();
                }
            }
        } else {
            EventMessage message = this.nextDownQueueEvent();
            if (message == null && (oldStatus & 0x10) != 0) {
                while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = oldStatus & 0xFFFFFFEF)) {
                }
                message = this.nextDownCueEvent();
            }
            if (message != null) {
                this.pullDownEvent(message);
                this.linkBinding.pushDown((Envelope)message);
                while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x14) == 0 && this.downQueueIsEmpty() ? oldStatus & 0xFFFFFFDF : oldStatus | 0x20) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                }
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            } else if ((oldStatus & 4) != 0) {
                SyncedResponse response = this.syncedResponse();
                this.pullDownSynced(response);
                this.linkBinding.pushDown((Envelope)response);
                while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = this.status) & 0x10) == 0 && this.downQueueIsEmpty() ? oldStatus & 0xFFFFFFDB : oldStatus & 0xFFFFFFFB)) {
                }
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            } else {
                this.linkBinding.skipDown();
                do {
                    if (((oldStatus = this.status) & 0x10) != 0 || !this.downQueueIsEmpty()) {
                        newStatus = oldStatus;
                        break;
                    }
                    newStatus = oldStatus & 0xFFFFFFDF;
                } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            }
        }
    }

    protected void pullDownEvent(EventMessage message) {
        this.onEvent(message);
        this.dispatchOnEvent(message);
    }

    protected void pullDownLinked(LinkedResponse response) {
        this.didLink(response);
        this.dispatchOnLinked(response);
    }

    protected void pullDownSynced(SyncedResponse response) {
        this.didSync(response);
        this.dispatchOnSynced(response);
    }

    protected void pullDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
        this.dispatchOnUnlinked(response);
    }

    public void cueUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) != 0 ? oldStatus & 0xFFFFFFBF | 0x80 : oldStatus & 0xFFFFFF7F) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    @Override
    public void feedUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x80) == 0 ? oldStatus & 0xFFFFFFBF | 0x80 : oldStatus | 0x40) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x80) == 0) {
            this.linkBinding.pullUp();
        }
    }

    @Override
    public void pushUp(Envelope envelope) {
        if (envelope instanceof CommandMessage) {
            this.pushUpCommand((CommandMessage)envelope);
        } else if (envelope instanceof LinkRequest) {
            this.pushUpLink((LinkRequest)envelope);
        } else if (envelope instanceof SyncRequest) {
            this.pushUpSync((SyncRequest)envelope);
        } else if (envelope instanceof UnlinkRequest) {
            this.pushUpUnlink((UnlinkRequest)envelope);
        } else {
            this.pushUpEnvelope(envelope);
        }
    }

    protected void pushUpCommand(CommandMessage message) {
        this.onCommand(message);
        this.laneBinding().pushUpCommand(message);
        if (!this.dispatchOnCommand(message, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnCommand(this, message));
        } else {
            this.cueUp();
        }
    }

    protected void runOnCommand(CommandMessage message) {
        block6: {
            try {
                this.dispatchOnCommand(message, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpLink(LinkRequest request) {
        this.willLink(request);
        if (!this.dispatchOnLink(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnLink(this, request));
        } else {
            this.cueUp();
        }
    }

    protected void runOnLink(LinkRequest request) {
        block6: {
            try {
                this.dispatchOnLink(request, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpSync(SyncRequest request) {
        this.willSync(request);
        if (!this.dispatchOnSync(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnSync(this, request));
        } else {
            this.cueUp();
        }
    }

    protected void runOnSync(SyncRequest request) {
        block6: {
            try {
                this.dispatchOnSync(request, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
        if (!this.dispatchOnUnlink(request, true)) {
            this.stage().execute((Runnable)new WarpUplinkModemOnUnlink(this, request));
        }
    }

    protected void runOnUnlink(UnlinkRequest request) {
        try {
            this.dispatchOnUnlink(request, false);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void pushUpEnvelope(Envelope envelope) {
        this.cueUp();
    }

    @Override
    public void skipUp() {
        this.cueUp();
    }

    public void unlink() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFF8 | 0x20 | 8) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void onEvent(EventMessage message) {
    }

    protected void onCommand(CommandMessage message) {
    }

    protected void willLink(LinkRequest request) {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x20 | 2 | 1 : oldStatus | 0x20 | 2 | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didLink(LinkedResponse response) {
    }

    protected void willSync(SyncRequest request) {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 1) == 0) {
                if ((oldStatus & 0x40) == 0) {
                    newStatus = oldStatus & 0xFFFFFF7F | 0x20 | 4 | 2 | 1;
                    continue;
                }
                newStatus = oldStatus | 0x20 | 4 | 2 | 1;
                continue;
            }
            newStatus = (oldStatus & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x20 | 4 : oldStatus | 0x20 | 4;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didSync(SyncedResponse response) {
    }

    protected void willUnlink(UnlinkRequest request) {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF78 | 0x20 | 8 : oldStatus & 0xFFFFFFF8 | 0x20 | 8) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didUnlink(UnlinkedResponse response) {
        this.close();
    }

    protected LinkedResponse linkedResponse() {
        return new LinkedResponse(this.nodeUri(), this.laneUri(), this.prio(), this.rate(), this.body());
    }

    protected SyncedResponse syncedResponse() {
        return new SyncedResponse(this.nodeUri(), this.laneUri());
    }

    protected UnlinkedResponse unlinkedResponse() {
        return new UnlinkedResponse(this.nodeUri(), this.laneUri());
    }
}

