/*
 * Decompiled with CFR 0.152.
 */
package swim.api.plane;

import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentRoute;
import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.plane.Plane;
import swim.api.plane.PlaneContext;
import swim.api.ref.HostRef;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.api.ref.SwimRef;
import swim.api.ws.WsDownlink;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriPattern;
import swim.util.Log;

public class AbstractPlane
implements Plane,
SwimRef,
Log {
    protected final PlaneContext context;

    public AbstractPlane(PlaneContext context) {
        this.context = context;
    }

    public AbstractPlane() {
        this(SwimContext.getPlaneContext());
    }

    @Override
    public PlaneContext planeContext() {
        return this.context;
    }

    public Schedule schedule() {
        return this.context.schedule();
    }

    public Stage stage() {
        return this.context.stage();
    }

    public <A extends Agent> AgentRoute<A> createAgentRoute(Class<? extends A> agentClass) {
        return this.context.createAgentRoute(agentClass);
    }

    public <A extends Agent> AgentRoute<A> getAgentRoute(String routeName) {
        return this.context.getAgentRoute(routeName);
    }

    public void addAgentRoute(String routeName, UriPattern pattern, AgentRoute<?> agentRoute) {
        this.context.addAgentRoute(routeName, pattern, agentRoute);
    }

    public void addAgentRoute(String routeName, String pattern, AgentRoute<?> agentRoute) {
        this.context.addAgentRoute(routeName, pattern, agentRoute);
    }

    public void removeAgentRoute(String routeName) {
        this.context.removeAgentRoute(routeName);
    }

    public AgentFactory<?> getAgentFactory(Uri nodeUri) {
        return this.context.getAgentFactory(nodeUri);
    }

    @Override
    public EventDownlink<Value> downlink() {
        return this.context.downlink();
    }

    @Override
    public ListDownlink<Value> downlinkList() {
        return this.context.downlinkList();
    }

    @Override
    public MapDownlink<Value, Value> downlinkMap() {
        return this.context.downlinkMap();
    }

    @Override
    public ValueDownlink<Value> downlinkValue() {
        return this.context.downlinkValue();
    }

    @Override
    public <V> HttpDownlink<V> downlinkHttp() {
        return this.context.downlinkHttp();
    }

    @Override
    public <I, O> WsDownlink<I, O> downlinkWs() {
        return this.context.downlinkWs();
    }

    @Override
    public HostRef hostRef(Uri hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public HostRef hostRef(String hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public NodeRef nodeRef(Uri hostUri, Uri nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public NodeRef nodeRef(String hostUri, String nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public NodeRef nodeRef(Uri nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public NodeRef nodeRef(String nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public LaneRef laneRef(Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(String hostUri, String nodeUri, String laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(String nodeUri, String laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(String hostUri, String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public void command(String hostUri, String nodeUri, String laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public void command(Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    @Override
    public void command(String nodeUri, String laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    public void trace(Object message) {
        this.context.trace(message);
    }

    public void debug(Object message) {
        this.context.debug(message);
    }

    public void info(Object message) {
        this.context.info(message);
    }

    public void warn(Object message) {
        this.context.warn(message);
    }

    public void error(Object message) {
        this.context.error(message);
    }

    @Override
    public void close() {
        this.context.close();
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willClose() {
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
    }
}

