/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetSocketAddress;
import swim.collections.FingerTrieSeq;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.io.IpInterface;
import swim.io.IpModem;
import swim.io.IpSocket;
import swim.io.IpSocketModem;
import swim.io.IpSocketRef;
import swim.io.http.HttpClient;
import swim.io.http.HttpClientModem;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.io.warp.WarpWebSocket;
import swim.remote.RemoteHost;
import swim.remote.RemoteHostClientBinding;
import swim.remote.RemoteHostClientReconnectTimer;
import swim.runtime.HostContext;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.ws.WsRequest;

public class RemoteHostClient
extends RemoteHost {
    final IpInterface endpoint;
    final WarpSettings warpSettings;
    HttpClient client;
    TimerRef reconnectTimer;
    double reconnectTimeout;
    static final double MAX_RECONNECT_TIMEOUT = 15000.0;
    static final FingerTrieSeq<String> PROTOCOL_LIST = FingerTrieSeq.of((Object)"warp0", (Object)"swim-0.0");

    public RemoteHostClient(Uri baseUri, IpInterface endpoint, WarpSettings warpSettings) {
        super(Uri.empty(), baseUri);
        this.endpoint = endpoint;
        this.warpSettings = warpSettings;
    }

    public RemoteHostClient(Uri baseUri, IpInterface endpoint) {
        this(baseUri, endpoint, WarpSettings.standard());
    }

    @Override
    public void setHostContext(HostContext hostContext) {
        super.setHostContext(hostContext);
    }

    public void connect() {
        int requestPort;
        String scheme = this.baseUri.schemeName();
        boolean isSecure = "warps".equals(scheme) || "swims".equals(scheme);
        UriAuthority remoteAuthority = this.baseUri.authority();
        String remoteAddress = remoteAuthority.host().address();
        int remotePort = remoteAuthority.port().number();
        int n = remotePort > 0 ? remotePort : (requestPort = isSecure ? 443 : 80);
        if (this.client == null) {
            Uri requestUri = Uri.from((UriScheme)UriScheme.from((String)"http"), (UriAuthority)remoteAuthority, (UriPath)UriPath.slash(), (UriQuery)this.baseUri.query());
            WsRequest wsRequest = WsRequest.from((Uri)requestUri, PROTOCOL_LIST);
            WarpWebSocket webSocket = new WarpWebSocket((WarpSocket)this, this.warpSettings);
            this.client = new RemoteHostClientBinding(this, webSocket, wsRequest, this.warpSettings);
            this.setWarpSocketContext((WarpSocketContext)webSocket);
        }
        if (isSecure) {
            this.connectHttps(new InetSocketAddress(remoteAddress, requestPort), this.client, this.warpSettings.httpSettings());
        } else {
            this.connectHttp(new InetSocketAddress(remoteAddress, requestPort), this.client, this.warpSettings.httpSettings());
        }
    }

    protected IpSocketRef connectHttp(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        IpSocketModem socket = new IpSocketModem((IpModem)modem);
        return this.endpoint.connectTcp(remoteAddress, (IpSocket)socket, httpSettings.ipSettings());
    }

    protected IpSocketRef connectHttps(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        IpSocketModem socket = new IpSocketModem((IpModem)modem);
        return this.endpoint.connectTls(remoteAddress, (IpSocket)socket, httpSettings.ipSettings());
    }

    @Override
    protected void reconnect() {
        if (this.reconnectTimer != null && this.reconnectTimer.isScheduled()) {
            return;
        }
        if (this.reconnectTimeout == 0.0) {
            double jitter = 1000.0 * Math.random();
            this.reconnectTimeout = 500.0 + jitter;
        } else {
            this.reconnectTimeout = Math.min(1.8 * this.reconnectTimeout, 15000.0);
        }
        this.reconnectTimer = this.hostContext.schedule().setTimer((long)this.reconnectTimeout, (TimerFunction)new RemoteHostClientReconnectTimer(this));
    }

    @Override
    public void didConnect() {
        if (this.reconnectTimer != null) {
            this.reconnectTimer.cancel();
            this.reconnectTimer = null;
        }
        this.reconnectTimeout = 0.0;
        super.didConnect();
    }

    @Override
    protected void willOpen() {
        this.connect();
        super.willOpen();
    }
}

