/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import swim.collections.BTreeContext;
import swim.collections.BTreeLeaf;
import swim.collections.BTreeNodeCursor;
import swim.collections.BTreePage;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

class BTreeNode<K, V, U>
extends BTreePage<K, V, U> {
    final BTreePage<K, V, U>[] pages;
    final K[] knots;
    final U fold;
    final int size;

    BTreeNode(BTreePage<K, V, U>[] pages, K[] knots, U fold, int size) {
        this.pages = pages;
        this.knots = knots;
        this.fold = fold;
        this.size = size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final int arity() {
        return this.pages.length;
    }

    @Override
    public final U fold() {
        return this.fold;
    }

    @Override
    public final K minKey() {
        return this.pages[0].minKey();
    }

    @Override
    public final K maxKey() {
        return this.pages[this.pages.length - 1].maxKey();
    }

    @Override
    public final boolean containsKey(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        if (x > 0) {
            ++x;
        } else if (x < 0) {
            x = -(x + 1);
        } else {
            return true;
        }
        return this.pages[x].containsKey(key, tree);
    }

    @Override
    public final boolean containsValue(Object value) {
        BTreePage<K, V, U>[] pages = this.pages;
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            if (!pages[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        int count = 0;
        for (int i = 0; i < x; ++i) {
            count += this.pages[x].size();
        }
        int index = this.pages[x].indexOf(key, tree);
        if (index >= 0) {
            return count + index;
        }
        return index - count;
    }

    @Override
    public final V get(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        return this.pages[x].get(key, tree);
    }

    @Override
    public final Map.Entry<K, V> getEntry(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        return this.pages[x].getEntry(key, tree);
    }

    @Override
    public final Map.Entry<K, V> getIndex(int index) {
        for (BTreePage<K, V, U> page : this.pages) {
            if (index < page.size()) {
                return page.getIndex(index);
            }
            index -= page.size();
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> firstEntry() {
        BTreePage<K, V, U>[] pages = this.pages;
        if (pages.length != 0) {
            return pages[0].firstEntry();
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> lastEntry() {
        BTreePage<K, V, U>[] pages = this.pages;
        if (pages.length != 0) {
            return pages[pages.length - 1].lastEntry();
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> nextEntry(K key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage<K, V, U>[] pages = this.pages;
        Map.Entry<K, V> entry = pages[x].nextEntry(key, tree);
        if (entry == null && x + 1 < pages.length) {
            entry = pages[x + 1].nextEntry(key, tree);
        }
        return entry;
    }

    @Override
    public final Map.Entry<K, V> previousEntry(K key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage<K, V, U>[] pages = this.pages;
        Map.Entry<K, V> entry = pages[x].previousEntry(key, tree);
        if (entry == null && x > 0) {
            entry = pages[x - 1].previousEntry(key, tree);
        }
        return entry;
    }

    @Override
    public final BTreeNode<K, V, U> updated(K key, V newValue, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage<K, V, U> oldPage = this.pages[x];
        BTreePage<K, V, U> newPage = oldPage.updated(key, newValue, tree);
        if (oldPage != newPage) {
            if (oldPage.size() != newPage.size() && tree.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage);
            }
            return this.updatedPage(x, newPage, oldPage);
        }
        return this;
    }

    private BTreeNode<K, V, U> updatedPage(int x, BTreePage<K, V, U> newPage, BTreePage<K, V, U> oldPage) {
        Object[] newKnots;
        BTreePage<K, V, U>[] oldPages = this.pages;
        int n = oldPages.length;
        BTreePage[] newPages = new BTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, n);
        newPages[x] = newPage;
        K[] oldKnots = this.knots;
        if (n - 1 > 0) {
            newKnots = new Object[n - 1];
            System.arraycopy(oldKnots, 0, newKnots, 0, n - 1);
            if (x > 0) {
                newKnots[x - 1] = newPage.minKey();
            }
        } else {
            newKnots = new Object[]{};
        }
        int newSize = this.size - oldPage.size() + newPage.size();
        return this.newNode(newPages, newKnots, null, newSize);
    }

    private BTreeNode<K, V, U> updatedPageSplit(int x, BTreePage<K, V, U> newPage, BTreePage<K, V, U> oldPage) {
        BTreePage<K, V, U>[] oldPages = this.pages;
        int n = oldPages.length + 1;
        BTreePage[] newPages = new BTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        int y = newPage.arity() >>> 1;
        BTreePage<K, V, U> newLeftPage = newPage.splitLeft(y);
        BTreePage<K, V, U> newRightPage = newPage.splitRight(y);
        newPages[x] = newLeftPage;
        newPages[x + 1] = newRightPage;
        System.arraycopy(oldPages, x + 1, newPages, x + 2, n - (x + 2));
        K[] oldKnots = this.knots;
        Object[] newKnots = new Object[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnots, 0, newKnots, 0, x - 1);
            newKnots[x - 1] = newLeftPage.minKey();
            newKnots[x] = newRightPage.minKey();
            System.arraycopy(oldKnots, x, newKnots, x + 1, n - (x + 2));
        } else {
            newKnots[0] = newRightPage.minKey();
            System.arraycopy(oldKnots, 0, newKnots, 1, n - 2);
        }
        int newSize = this.size - oldPage.size() + newPage.size();
        return this.newNode(newPages, newKnots, null, newSize);
    }

    private BTreeNode<K, V, U> updatedPageMerge(int x, BTreeNode<K, V, U> newPage, BTreePage<K, V, U> oldPage) {
        BTreePage<K, V, U>[] oldPages = this.pages;
        BTreePage<K, V, U>[] midPages = newPage.pages;
        int k = midPages.length;
        int n = oldPages.length + (k - 1);
        BTreePage[] newPages = new BTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        System.arraycopy(midPages, 0, newPages, x, k);
        System.arraycopy(oldPages, x + 1, newPages, x + k, n - (x + k));
        K[] oldKnots = this.knots;
        K[] midKnots = newPage.knots;
        Object[] newKnots = new Object[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnots, 0, newKnots, 0, x - 1);
            newKnots[x - 1] = midPages[0].minKey();
            System.arraycopy(midKnots, 0, newKnots, x, k - 1);
            System.arraycopy(oldKnots, x, newKnots, x + (k - 1), n - (x + k));
        } else {
            System.arraycopy(midKnots, 0, newKnots, 0, k - 1);
            newKnots[midKnots.length] = oldPages[1].minKey();
            System.arraycopy(oldKnots, 1, newKnots, k, n - k - 1);
        }
        int newSize = this.size - oldPage.size() + newPage.size();
        return this.newNode(newPages, newKnots, null, newSize);
    }

    @Override
    public final BTreePage<K, V, U> removed(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage<K, V, U> oldPage = this.pages[x];
        BTreePage<K, V, U> newPage = oldPage.removed(key, tree);
        if (oldPage != newPage) {
            return this.replacedPage(x, newPage, oldPage, tree);
        }
        return this;
    }

    private BTreePage<K, V, U> replacedPage(int x, BTreePage<K, V, U> newPage, BTreePage<K, V, U> oldPage, BTreeContext<K, V> tree) {
        if (!newPage.isEmpty()) {
            if (newPage instanceof BTreeNode && tree.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(x, (BTreeNode)newPage, oldPage);
            }
            return this.updatedPage(x, newPage, oldPage);
        }
        if (this.pages.length > 2) {
            return this.removedPage(x, newPage, oldPage);
        }
        if (this.pages.length > 1) {
            if (x == 0) {
                return this.pages[1];
            }
            return this.pages[0];
        }
        return BTreeLeaf.empty();
    }

    private BTreeNode<K, V, U> removedPage(int x, BTreePage<K, V, U> newPage, BTreePage<K, V, U> oldPage) {
        BTreePage<K, V, U>[] oldPages = this.pages;
        int n = oldPages.length - 1;
        BTreePage[] newPages = new BTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, x);
        System.arraycopy(oldPages, x + 1, newPages, x, n - x);
        K[] oldKnots = this.knots;
        Object[] newKnots = new Object[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnots, 0, newKnots, 0, x - 1);
            System.arraycopy(oldKnots, x, newKnots, x - 1, n - x);
        } else {
            System.arraycopy(oldKnots, 1, newKnots, 0, n - 1);
        }
        int newSize = this.size - oldPage.size();
        return this.newNode(newPages, newKnots, null, newSize);
    }

    @Override
    public final BTreePage<K, V, U> drop(int lower, BTreeContext<K, V> tree) {
        if (lower > 0) {
            int newSize = this.size;
            if (lower < newSize) {
                int x;
                int childSize;
                BTreePage<K, V, U>[] oldPages = this.pages;
                int k = oldPages.length;
                for (x = 0; x < k && (childSize = oldPages[x].size()) <= lower; lower -= childSize, ++x) {
                    newSize -= childSize;
                }
                int n = k - x;
                if (n > 1) {
                    BTreeNode<Object, V, Object> newNode;
                    if (x > 0) {
                        BTreePage[] newPages = new BTreePage[n];
                        System.arraycopy(oldPages, x, newPages, 0, n);
                        Object[] newKnots = new Object[n - 1];
                        System.arraycopy(this.knots, x, newKnots, 0, n - 1);
                        for (int i = 0; i < newKnots.length; ++i) {
                            newKnots[i] = this.knots[i + x];
                        }
                        newNode = this.newNode(newPages, newKnots, null, newSize);
                    } else {
                        newNode = this;
                    }
                    if (lower > 0) {
                        BTreePage<K, V, U> oldPage = oldPages[x];
                        BTreePage<K, V, U> newPage = oldPage.drop(lower, tree);
                        return newNode.replacedPage(0, newPage, oldPage, tree);
                    }
                    return newNode;
                }
                return oldPages[x].drop(lower, tree);
            }
            return BTreeLeaf.empty();
        }
        return this;
    }

    @Override
    public final BTreePage<K, V, U> take(int upper, BTreeContext<K, V> tree) {
        if (upper < this.size) {
            if (upper > 0) {
                int n;
                int childSize;
                int x;
                BTreePage<K, V, U>[] oldPages = this.pages;
                int k = oldPages.length;
                int newSize = 0;
                for (x = 0; x < k && upper > 0; ++x, upper -= childSize) {
                    childSize = oldPages[x].size();
                    newSize += childSize;
                    if (childSize > upper) break;
                }
                int n2 = n = upper == 0 ? x : x + 1;
                if (n > 1) {
                    BTreeNode<Object, V, Object> newNode;
                    if (x < k) {
                        BTreePage[] newPages = new BTreePage[n];
                        System.arraycopy(oldPages, 0, newPages, 0, n);
                        Object[] newKnots = new Object[n - 1];
                        System.arraycopy(this.knots, 0, newKnots, 0, n - 1);
                        newNode = this.newNode(newPages, newKnots, null, newSize);
                    } else {
                        newNode = this;
                    }
                    if (upper > 0) {
                        BTreePage<K, V, U> oldPage = oldPages[x - 1];
                        BTreePage<K, V, U> newPage = oldPage.take(upper, tree);
                        return newNode.replacedPage(x - 1, newPage, oldPage, tree);
                    }
                    return newNode;
                }
                if (upper > 0) {
                    return oldPages[0].take(upper, tree);
                }
                return oldPages[0];
            }
            return BTreeLeaf.empty();
        }
        return this;
    }

    @Override
    public final BTreeNode<K, V, U> balanced(BTreeContext<K, V> tree) {
        if (this.pages.length > 1 && tree.pageShouldSplit(this)) {
            int x = this.knots.length >>> 1;
            return this.split(x);
        }
        return this;
    }

    @Override
    public final BTreeNode<K, V, U> split(int x) {
        BTreePage[] newPages = new BTreePage[2];
        BTreePage newLeftPage = this.splitLeft(x);
        BTreePage newRightPage = this.splitRight(x);
        newPages[0] = newLeftPage;
        newPages[1] = newRightPage;
        Object[] newKnots = new Object[]{((BTreeNode)newRightPage).minKey()};
        return this.newNode(newPages, newKnots, null, this.size);
    }

    @Override
    public final BTreeNode<K, V, U> splitLeft(int x) {
        BTreePage<K, V, U>[] oldPages = this.pages;
        BTreePage[] newPages = new BTreePage[x + 1];
        System.arraycopy(oldPages, 0, newPages, 0, x + 1);
        K[] oldKnots = this.knots;
        Object[] newKnots = new Object[x];
        System.arraycopy(oldKnots, 0, newKnots, 0, x);
        int newSize = 0;
        for (int i = 0; i <= x; ++i) {
            newSize += newPages[i].size();
        }
        return this.newNode(newPages, newKnots, null, newSize);
    }

    @Override
    public final BTreeNode<K, V, U> splitRight(int x) {
        BTreePage<K, V, U>[] oldPages = this.pages;
        int y = oldPages.length - (x + 1);
        BTreePage[] newPages = new BTreePage[y];
        System.arraycopy(oldPages, x + 1, newPages, 0, y);
        K[] oldKnots = this.knots;
        Object[] newKnots = new Object[y - 1];
        System.arraycopy(oldKnots, x + 1, newKnots, 0, y - 1);
        int newSize = 0;
        for (int i = 0; i < y; ++i) {
            newSize += newPages[i].size();
        }
        return this.newNode(newPages, newKnots, null, newSize);
    }

    @Override
    public final BTreeNode<K, V, U> reduced(U identity, CombinerFunction<? super V, U> accumulator, CombinerFunction<U, U> combiner) {
        if (this.fold == null) {
            BTreePage<K, V, U>[] oldPages = this.pages;
            int n = oldPages.length;
            BTreePage[] newPages = new BTreePage[n];
            for (int i = 0; i < n; ++i) {
                newPages[i] = oldPages[i].reduced(identity, accumulator, combiner);
            }
            Object fold = newPages[0].fold();
            for (int i = 1; i < n; ++i) {
                fold = combiner.combine(fold, newPages[i].fold());
            }
            return this.newNode(newPages, this.knots, fold, this.size);
        }
        return this;
    }

    @Override
    public final OrderedMapCursor<K, V> iterator() {
        return new BTreeNodeCursor<K, V, U>(this.pages);
    }

    @Override
    public final OrderedMapCursor<K, V> lastIterator() {
        return new BTreeNodeCursor<K, V, U>(this.pages, this.size, this.pages.length);
    }

    protected final int lookup(Object key, BTreeContext<K, V> tree) {
        int lo = 0;
        int hi = this.knots.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int order = tree.compareKey(key, this.knots[mid]);
            if (order > 0) {
                lo = mid + 1;
                continue;
            }
            if (order < 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -(lo + 1);
    }

    protected BTreeNode<K, V, U> newNode(BTreePage<K, V, U>[] pages, K[] knots, U fold, int size) {
        return new BTreeNode<K, V, U>(pages, knots, fold, size);
    }
}

