/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import swim.collections.FingerTrieSeq;

final class FingerTrieSeqSegmenter
implements ListIterator<Object[]> {
    final Object[] prefix;
    final FingerTrieSeq<Object[]> branch;
    final Object[] suffix;
    FingerTrieSeqSegmenter inner;
    Object[] infix;
    int infixIndex;
    int index;
    int phase;

    FingerTrieSeqSegmenter(FingerTrieSeq<?> trie) {
        this.prefix = trie.prefix;
        this.branch = trie.branch;
        this.suffix = trie.suffix;
        this.phase = trie.length > 0 ? 0 : 3;
    }

    FingerTrieSeqSegmenter(FingerTrieSeq<?> trie, int index) {
        this.prefix = trie.prefix;
        this.branch = trie.branch;
        this.suffix = trie.suffix;
        this.index = index;
        if (index == 0) {
            this.phase = 0;
        } else if (index - 1 < this.branch.length) {
            this.inner = new FingerTrieSeqSegmenter(this.branch, index - 1 >> 5);
            this.infix = this.inner.next();
            this.infixIndex = index - 1 & 0x1F;
            this.phase = 1;
        } else {
            this.phase = index == 1 + this.branch.length && this.suffix.length > 0 ? 2 : 3;
        }
    }

    @Override
    public boolean hasNext() {
        return this.phase < 3;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public Object[] next() {
        switch (this.phase) {
            case 0: {
                ++this.index;
                if (this.branch.length > 0) {
                    this.inner = new FingerTrieSeqSegmenter(this.branch);
                    this.infix = this.inner.next();
                    this.infixIndex = 0;
                    this.phase = 1;
                } else {
                    this.phase = this.suffix.length > 0 ? 2 : 3;
                }
                return this.prefix;
            }
            case 1: {
                Object[] head = (Object[])this.infix[this.infixIndex];
                ++this.infixIndex;
                ++this.index;
                if (this.infixIndex >= this.infix.length) {
                    if (this.inner.hasNext()) {
                        this.infix = this.inner.next();
                        this.infixIndex = 0;
                    } else {
                        this.inner = null;
                        this.phase = 2;
                    }
                }
                return head;
            }
            case 2: {
                ++this.index;
                this.phase = 3;
                return this.suffix;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.phase > 0;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public Object[] previous() {
        switch (this.phase) {
            case 1: {
                --this.index;
                if (this.infixIndex > 0) {
                    --this.infixIndex;
                    return (Object[])this.infix[this.infixIndex];
                }
                this.inner.previous();
                if (this.inner.hasPrevious()) {
                    this.infix = this.inner.previous();
                    this.infixIndex = this.infix.length - 1;
                    this.inner.next();
                    return (Object[])this.infix[this.infixIndex];
                }
                this.inner = null;
                this.phase = 0;
                return this.prefix;
            }
            case 2: {
                --this.index;
                if (this.branch.length > 0) {
                    if (this.inner == null) {
                        this.inner = new FingerTrieSeqSegmenter(this.branch, this.branch.length);
                    }
                    this.infix = this.inner.previous();
                    this.infixIndex = this.infix.length - 1;
                    this.inner.next();
                    this.phase = 1;
                    return (Object[])this.infix[this.infixIndex];
                }
                this.phase = 0;
                return this.prefix;
            }
            case 3: {
                --this.index;
                if (this.suffix.length > 0) {
                    this.phase = 2;
                    return this.suffix;
                }
                if (this.branch.length > 0) {
                    if (this.inner == null) {
                        this.inner = new FingerTrieSeqSegmenter(this.branch, this.branch.length);
                    }
                    this.infix = this.inner.previous();
                    this.infixIndex = this.infix.length - 1;
                    this.inner.next();
                    this.phase = 1;
                    return (Object[])this.infix[this.infixIndex];
                }
                this.phase = 0;
                return this.prefix;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void add(Object[] segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Object[] segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

