/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.STreeContext;
import swim.collections.STreePage;
import swim.collections.STreeSubList;
import swim.util.Cursor;
import swim.util.KeyedList;
import swim.util.Murmur3;

public class STree<T>
extends STreeContext<T>
implements KeyedList<T>,
Cloneable,
Debug {
    STreePage<T> root;
    private static int hashSeed;

    protected STree(STreePage<T> root) {
        this.root = root;
    }

    public STree() {
        this(STreePage.empty());
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public int size() {
        return this.root.size();
    }

    public boolean contains(Object value) {
        return this.root.contains(value);
    }

    public boolean containsAll(Collection<?> values) {
        STreePage<T> root = this.root;
        for (Object value : values) {
            if (root.contains(value)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object value) {
        return this.root.indexOf(value);
    }

    public int lastIndexOf(Object value) {
        return this.root.lastIndexOf(value);
    }

    public T get(int index) {
        return this.get(index, null);
    }

    public T get(int index, Object key) {
        if (key != null && (index = this.lookup(index, key)) < 0) {
            return null;
        }
        return this.root.get(index);
    }

    public Map.Entry<Object, T> getEntry(int index) {
        return this.getEntry(index, null);
    }

    public Map.Entry<Object, T> getEntry(int index, Object key) {
        if (key != null && (index = this.lookup(index, key)) < 0) {
            return null;
        }
        return this.root.getEntry(index);
    }

    public T set(int index, T newValue) {
        return this.set(index, newValue, null);
    }

    public T set(int index, T newValue, Object key) {
        if (key != null && (index = this.lookup(index, key)) < 0) {
            throw new NoSuchElementException(key.toString());
        }
        STreePage<T> oldRoot = this.root;
        if (index < 0 || index >= oldRoot.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        STreePage<T> newRoot = oldRoot.updated(index, newValue, this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return oldRoot.get(index);
        }
        return null;
    }

    public boolean add(T newValue) {
        return this.add(newValue, null);
    }

    public boolean add(T newValue, Object key) {
        this.root = this.root.appended(newValue, key, this).balanced(this);
        return true;
    }

    public boolean addAll(Collection<? extends T> newValues) {
        boolean modified = false;
        for (T newValue : newValues) {
            this.add(newValue);
            modified = true;
        }
        return modified;
    }

    public void add(int index, T newValue) {
        this.add(index, newValue, null);
    }

    public void add(int index, T newValue, Object key) {
        STreePage<T> oldRoot = this.root;
        if (index < 0 || index > oldRoot.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.root = oldRoot.inserted(index, newValue, key, this).balanced(this);
    }

    public boolean addAll(int index, Collection<? extends T> newValues) {
        boolean modified = false;
        for (T newValue : newValues) {
            this.add(index, newValue);
            ++index;
            modified = true;
        }
        return modified;
    }

    public T remove(int index) {
        return this.remove(index, null);
    }

    public T remove(int index, Object key) {
        if (key != null && (index = this.lookup(index, key)) < 0) {
            return null;
        }
        STreePage<T> oldRoot = this.root;
        if (index < 0 || index > oldRoot.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        STreePage<T> newRoot = oldRoot.removed(index, (STreeContext<T>)this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return oldRoot.get(index);
        }
        return null;
    }

    public boolean remove(Object value) {
        STreePage<T> oldRoot = this.root;
        STreePage<T> newRoot = oldRoot.removed(value, this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<?> values) {
        STreePage<T> oldRoot;
        STreePage<T> newRoot = oldRoot = this.root;
        int n = newRoot.size();
        int i = 0;
        while (i < n) {
            T value = newRoot.get(i);
            if (values.contains(value)) {
                newRoot = newRoot.removed(i, (STreeContext<T>)this);
                --n;
                continue;
            }
            ++i;
        }
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection<?> values) {
        STreePage<T> oldRoot;
        STreePage<T> newRoot = oldRoot = this.root;
        int n = newRoot.size();
        int i = 0;
        while (i < n) {
            T value = newRoot.get(i);
            if (!values.contains(value)) {
                newRoot = newRoot.removed(i, (STreeContext<T>)this);
                --n;
                continue;
            }
            ++i;
        }
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return true;
        }
        return false;
    }

    public void move(int fromIndex, int toIndex) {
        this.move(fromIndex, toIndex, null);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        if (key != null && (fromIndex = this.lookup(fromIndex, key)) < 0) {
            throw new NoSuchElementException(key.toString());
        }
        STreePage<T> oldRoot = this.root;
        if (fromIndex < 0 || fromIndex >= oldRoot.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(fromIndex));
        }
        if (toIndex < 0 || toIndex >= oldRoot.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(toIndex));
        }
        if (fromIndex != toIndex) {
            Map.Entry<Object, T> entry = oldRoot.getEntry(fromIndex);
            this.root = oldRoot.removed(fromIndex, (STreeContext<T>)this).inserted(toIndex, entry.getValue(), entry.getKey(), this).balanced(this);
        }
    }

    public void drop(int lower) {
        STreePage<T> oldRoot = this.root;
        if (lower > 0 && oldRoot.size() > 0) {
            this.root = lower < oldRoot.size() ? oldRoot.drop(lower, this) : STreePage.empty();
        }
    }

    public void take(int upper) {
        STreePage<T> oldRoot = this.root;
        if (upper < oldRoot.size() && oldRoot.size() > 0) {
            this.root = upper > 0 ? oldRoot.take(upper, this) : STreePage.empty();
        }
    }

    public void clear() {
        this.root = STreePage.empty();
    }

    public Object[] toArray() {
        STreePage<T> root = this.root;
        int n = root.size();
        Object[] array = new Object[n];
        root.copyToArray(array, 0);
        return array;
    }

    public <U> U[] toArray(U[] array) {
        STreePage<T> root = this.root;
        int n = root.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        root.copyToArray(array, 0);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    public Cursor<T> iterator() {
        return this.root.iterator();
    }

    public Cursor<T> listIterator() {
        return this.root.iterator();
    }

    public Cursor<T> listIterator(int index) {
        Cursor<T> cursor = this.listIterator();
        cursor.skip((long)index);
        return cursor;
    }

    public Cursor<Object> keyIterator() {
        return this.root.keyIterator();
    }

    public Cursor<Map.Entry<Object, T>> entryIterator() {
        return this.root.entryIterator();
    }

    public Cursor<T> reverseIterator() {
        return this.root.reverseIterator();
    }

    public Cursor<Object> reverseKeyIterator() {
        return this.root.reverseKeyIterator();
    }

    public Cursor<Map.Entry<Object, T>> reverseEntryIterator() {
        return this.root.reverseEntryIterator();
    }

    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        return new STreeSubList(this, fromIndex, toIndex);
    }

    public STree<T> clone() {
        return this.copy(this.root);
    }

    protected STree<T> copy(STreePage<T> root) {
        return new STree<T>(root);
    }

    @Override
    protected Object identify(T value) {
        return ThreadLocalRandom.current().nextLong();
    }

    @Override
    protected int compare(Object x, Object y) {
        return ((Comparable)x).compareTo(y);
    }

    @Override
    protected int pageSplitSize() {
        return 32;
    }

    @Override
    protected boolean pageShouldSplit(STreePage<T> page) {
        return page.arity() > this.pageSplitSize();
    }

    @Override
    protected boolean pageShouldMerge(STreePage<T> page) {
        return page.arity() < this.pageSplitSize() >>> 1;
    }

    protected int lookup(int start, Object key) {
        STreePage<T> root = this.root;
        if ((start = Math.min(Math.max(0, start), root.size() - 1)) > -1) {
            int index = start;
            do {
                Map.Entry<Object, T> entry;
                if ((entry = root.getEntry(index)) == null || this.compare(entry.getKey(), key) != 0) continue;
                return index;
            } while ((index = (index + 1) % root.size()) != start);
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof STree) {
            STree that = (STree)other;
            if (this.size() == that.size()) {
                Cursor<T> these = this.iterator();
                Cursor<T> those = that.iterator();
                while (these.hasNext() && those.hasNext()) {
                    Object x = these.next();
                    Object y = those.next();
                    if (!(x == null ? y != null : !x.equals(y))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(STree.class);
        }
        int h = hashSeed;
        Cursor<T> these = this.iterator();
        while (these.hasNext()) {
            h = Murmur3.mix((int)h, (int)Murmur3.hash((Object)these.next()));
        }
        return Murmur3.mash((int)h);
    }

    public void debug(Output<?> output) {
        output = output.write("STree").write(46);
        Cursor<T> these = this.iterator();
        if (these.hasNext()) {
            output = output.write("of").write(40).debug(these.next());
            while (these.hasNext()) {
                output = output.write(", ").debug(these.next());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> STree<T> empty() {
        return new STree<T>();
    }

    public static <T> STree<T> of(T ... values) {
        STree<T> tree = new STree<T>();
        for (T value : values) {
            tree.add(value);
        }
        return tree;
    }
}

