/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractList;
import java.util.List;
import swim.collections.STree;

final class STreeSubList<T>
extends AbstractList<T> {
    final STree<T> inner;
    final int fromIndex;
    final int toIndex;

    STreeSubList(STree<T> inner, int fromIndex, int toIndex) {
        this.inner = inner;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public T get(int index) {
        int i = this.fromIndex + index;
        if (i < this.fromIndex || i >= this.toIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.inner.get(i);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        fromIndex += this.fromIndex;
        if ((toIndex += this.fromIndex) > this.toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new STreeSubList<T>(this.inner, fromIndex, toIndex);
    }
}

