/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.ParserException;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriException;

public class UriForm
extends Form<Uri> {
    final Uri unit;

    UriForm(Uri unit) {
        this.unit = unit;
    }

    public Uri unit() {
        return this.unit;
    }

    public Form<Uri> unit(Uri unit) {
        return new UriForm(unit);
    }

    public Class<Uri> type() {
        return Uri.class;
    }

    public Item mold(Uri value) {
        if (value != null) {
            return Text.from((String)value.toString());
        }
        return Item.extant();
    }

    public Uri cast(Item item) {
        Value value = item.target();
        try {
            String string = value.stringValue();
            if (string != null) {
                return Uri.parse(string);
            }
        }
        catch (UnsupportedOperationException | ParserException | UriException throwable) {
            // empty catch block
        }
        return null;
    }
}

