/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriParser;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;

final class UriPathParser
extends Parser<UriPath> {
    final UriParser uri;
    final UriPathBuilder builder;
    final Output<String> output;
    final int c1;
    final int step;

    UriPathParser(UriParser uri, UriPathBuilder builder, Output<String> output, int c1, int step) {
        this.uri = uri;
        this.builder = builder;
        this.output = output;
        this.c1 = c1;
        this.step = step;
    }

    UriPathParser(UriParser uri, UriPathBuilder builder) {
        this(uri, builder, null, 0, 1);
    }

    UriPathParser(UriParser uri) {
        this(uri, null, null, 0, 1);
    }

    public Parser<UriPath> feed(Input input) {
        return UriPathParser.parse(input, this.uri, this.builder, this.output, this.c1, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriPath> parse(Input input, UriParser uri, UriPathBuilder builder, Output<String> output, int c1, int step) {
        block18: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    while (input.isCont() && Uri.isPathChar(c = input.head())) {
                        if (output == null) {
                            output = Utf8.decodedString();
                        }
                        input = input.step();
                        output = output.write(c);
                    }
                    if (input.isCont() && c == 47) {
                        input = input.step();
                        if (builder == null) {
                            builder = uri.pathBuilder();
                        }
                        if (output != null) {
                            builder.addSegment((String)output.bind());
                            output = null;
                        }
                        builder.addSlash();
                        continue;
                    }
                    if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        if (output != null) {
                            if (builder == null) {
                                builder = uri.pathBuilder();
                            }
                            builder.addSegment((String)output.bind());
                        }
                        if (builder == null) return UriPathParser.done((Object)uri.pathEmpty());
                        return UriPathParser.done((Object)builder.bind());
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriPathParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return UriPathParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step != 3) break block18;
                if (!input.isCont()) break;
                c = input.head();
                if (!Base16.isDigit((int)c)) return UriPathParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                if (output == null) {
                    output = Utf8.decodedString();
                }
                input = input.step();
                output = output.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                c1 = 0;
                step = 1;
            }
            if (input.isDone()) {
                return UriPathParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new UriPathParser(uri, builder, (Output<String>)output, c1, step);
        return UriPathParser.error((Throwable)input.trap());
    }

    static Parser<UriPath> parse(Input input, UriParser uri, UriPathBuilder builder) {
        return UriPathParser.parse(input, uri, builder, null, 0, 1);
    }

    static Parser<UriPath> parse(Input input, UriParser uri) {
        return UriPathParser.parse(input, uri, null, null, 0, 1);
    }
}

