/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityPattern;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;
import swim.uri.UriPathLiteral;
import swim.uri.UriPathVariable;
import swim.uri.UriQuery;
import swim.uri.UriQueryPattern;
import swim.uri.UriScheme;

abstract class UriPathPattern
extends UriAuthorityPattern {
    UriPathPattern() {
    }

    Uri apply(UriScheme scheme, UriAuthority authority, UriPathBuilder path, String[] args, int index) {
        return this.apply(scheme, authority, path.bind(), args, index);
    }

    @Override
    Uri apply(UriScheme scheme, UriAuthority authority, String[] args, int index) {
        return this.apply(scheme, authority, new UriPathBuilder(), args, index);
    }

    abstract HashTrieMap<String, String> unapply(UriPath var1, UriQuery var2, UriFragment var3, HashTrieMap<String, String> var4);

    @Override
    HashTrieMap<String, String> unapply(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        return this.unapply(path, query, fragment, args);
    }

    abstract boolean matches(UriPath var1, UriQuery var2, UriFragment var3);

    @Override
    boolean matches(UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (!authority.isDefined()) {
            return this.matches(path, query, fragment);
        }
        return false;
    }

    static UriPathPattern compile(Uri pattern, UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty()) {
            String component = path.head();
            if (!component.isEmpty() && component.charAt(0) == ':') {
                return new UriPathVariable(component.substring(1), UriPathPattern.compile(pattern, path.tail(), query, fragment));
            }
            return new UriPathLiteral(component, UriPathPattern.compile(pattern, path.tail(), query, fragment));
        }
        return UriQueryPattern.compile(pattern, query, fragment);
    }
}

