/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriParser;
import swim.uri.UriQuery;
import swim.uri.UriQueryBuilder;

final class UriQueryParser
extends Parser<UriQuery> {
    final UriParser uri;
    final UriQueryBuilder builder;
    final Output<String> keyOutput;
    final Output<String> valueOutput;
    final int c1;
    final int step;

    UriQueryParser(UriParser uri, UriQueryBuilder builder, Output<String> keyOutput, Output<String> valueOutput, int c1, int step) {
        this.uri = uri;
        this.builder = builder;
        this.keyOutput = keyOutput;
        this.valueOutput = valueOutput;
        this.c1 = c1;
        this.step = step;
    }

    UriQueryParser(UriParser uri, UriQueryBuilder builder) {
        this(uri, builder, null, null, 0, 1);
    }

    UriQueryParser(UriParser uri) {
        this(uri, null, null, null, 0, 1);
    }

    public Parser<UriQuery> feed(Input input) {
        return UriQueryParser.parse(input, this.uri, this.builder, this.keyOutput, this.valueOutput, this.c1, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriQuery> parse(Input input, UriParser uri, UriQueryBuilder builder, Output<String> keyOutput, Output<String> valueOutput, int c1, int step) {
        block33: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (keyOutput == null) {
                        keyOutput = Utf8.decodedString();
                    }
                    while (input.isCont() && Uri.isParamChar(c = input.head())) {
                        input = input.step();
                        keyOutput.write(c);
                    }
                    if (input.isCont() && c == 61) {
                        input = input.step();
                        step = 4;
                    } else {
                        if (input.isCont() && c == 38) {
                            input = input.step();
                            if (builder == null) {
                                builder = uri.queryBuilder();
                            }
                            builder.addParam((String)keyOutput.bind());
                            keyOutput = null;
                            continue;
                        }
                        if (input.isCont() && c == 37) {
                            input = input.step();
                            step = 2;
                        } else if (!input.isEmpty()) {
                            if (builder == null) {
                                builder = uri.queryBuilder();
                            }
                            builder.addParam((String)keyOutput.bind());
                            return UriQueryParser.done((Object)builder.bind());
                        }
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        keyOutput.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                        c1 = 0;
                        step = 1;
                        continue;
                    }
                    if (input.isDone()) {
                        return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step == 4) {
                    if (valueOutput == null) {
                        valueOutput = Utf8.decodedString();
                    }
                    while (input.isCont() && (Uri.isParamChar(c = input.head()) || c == 61)) {
                        input = input.step();
                        valueOutput.write(c);
                    }
                    if (input.isCont() && c == 38) {
                        input = input.step();
                        if (builder == null) {
                            builder = uri.queryBuilder();
                        }
                        builder.addParam((String)keyOutput.bind(), (String)valueOutput.bind());
                        keyOutput = null;
                        valueOutput = null;
                        step = 1;
                        continue;
                    }
                    if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 5;
                    } else if (!input.isEmpty()) {
                        if (builder == null) {
                            builder = uri.queryBuilder();
                        }
                        builder.addParam((String)keyOutput.bind(), (String)valueOutput.bind());
                        return UriQueryParser.done((Object)builder.bind());
                    }
                }
                if (step == 5) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 6;
                    } else if (input.isDone()) {
                        return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step != 6) break block33;
                if (!input.isCont()) break;
                c = input.head();
                if (!Base16.isDigit((int)c)) return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                input = input.step();
                valueOutput.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                c1 = 0;
                step = 4;
            }
            if (input.isDone()) {
                return UriQueryParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new UriQueryParser(uri, builder, (Output<String>)keyOutput, (Output<String>)valueOutput, c1, step);
        return UriQueryParser.error((Throwable)input.trap());
    }

    static Parser<UriQuery> parse(Input input, UriParser uri, UriQueryBuilder builder) {
        return UriQueryParser.parse(input, uri, builder, null, null, 0, 1);
    }

    static Parser<UriQuery> parse(Input input, UriParser uri) {
        return UriQueryParser.parse(input, uri, null, null, null, 0, 1);
    }
}

