/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.BoxR2;
import swim.math.BoxZ2Form;
import swim.math.PointZ2;
import swim.math.Z2Form;
import swim.math.Z2Shape;
import swim.math.Z2ToR2Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class BoxZ2
extends Z2Shape
implements Debug {
    public final long xMin;
    public final long yMin;
    public final long xMax;
    public final long yMax;
    private static int hashSeed;
    private static Z2Form<BoxZ2> form;

    public BoxZ2(long xMin, long yMin, long xMax, long yMax) {
        this.xMin = xMin <= xMax ? xMin : xMax;
        this.yMin = yMin <= yMax ? yMin : yMax;
        this.xMax = xMin <= xMax ? xMax : xMin;
        this.yMax = yMin <= yMax ? yMax : yMin;
    }

    @Override
    public final long xMin() {
        return this.xMin;
    }

    @Override
    public final long yMin() {
        return this.yMin;
    }

    @Override
    public final long xMax() {
        return this.xMax;
    }

    @Override
    public final long yMax() {
        return this.yMax;
    }

    @Override
    public boolean contains(Z2Shape shape) {
        if (shape instanceof PointZ2) {
            return this.contains((PointZ2)shape);
        }
        if (shape instanceof BoxZ2) {
            return this.contains((BoxZ2)shape);
        }
        return this.xMin <= shape.xMin() && shape.xMax() <= this.xMax && this.yMin <= shape.yMin() && shape.yMax() <= this.yMax;
    }

    public boolean contains(PointZ2 point) {
        return this.xMin <= point.x && point.x <= this.xMax && this.yMin <= point.y && point.y <= this.yMax;
    }

    public boolean contains(BoxZ2 box) {
        return this.xMin <= box.xMin && box.xMax <= this.xMax && this.yMin <= box.yMin && box.yMax <= this.yMax;
    }

    @Override
    public boolean intersects(Z2Shape shape) {
        if (shape instanceof PointZ2) {
            return this.intersects((PointZ2)shape);
        }
        if (shape instanceof BoxZ2) {
            return this.intersects((BoxZ2)shape);
        }
        return shape.intersects(this);
    }

    public boolean intersects(PointZ2 point) {
        return this.xMin <= point.x && point.x <= this.xMax && this.yMin <= point.y && point.y <= this.yMax;
    }

    public boolean intersects(BoxZ2 box) {
        return this.xMin <= box.xMax && box.xMin <= this.xMax && this.yMin <= box.yMax && box.yMin <= this.yMax;
    }

    @Override
    public BoxR2 transform(Z2ToR2Function f) {
        return new BoxR2(f.transformX(this.xMin, this.yMin), f.transformY(this.xMin, this.yMin), f.transformX(this.xMax, this.yMax), f.transformY(this.xMax, this.yMax));
    }

    @Override
    public Value toValue() {
        return BoxZ2.form().mold(this).toValue();
    }

    protected boolean canEqual(BoxZ2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BoxZ2) {
            BoxZ2 that = (BoxZ2)other;
            return that.canEqual(this) && this.xMin == that.xMin && this.yMin == that.yMin && this.xMax == that.xMax && this.yMax == that.yMax;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(BoxZ2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.xMin)), (int)Murmur3.hash((long)this.yMin)), (int)Murmur3.hash((long)this.xMax)), (int)Murmur3.hash((long)this.yMax)));
    }

    public void debug(Output<?> output) {
        output.write("BoxZ2").write(46).write("of").write(40).debug((Object)this.xMin).write(", ").debug((Object)this.yMin).write(", ").debug((Object)this.xMax).write(", ").debug((Object)this.yMax).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static BoxZ2 of(long xMin, long yMin, long xMax, long yMax) {
        return new BoxZ2(xMin, yMin, xMax, yMax);
    }

    @Kind
    public static Z2Form<BoxZ2> form() {
        if (form == null) {
            form = new BoxZ2Form();
        }
        return form;
    }
}

