/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.R3Form;
import swim.math.SphereR3;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class SphereR3Form
extends R3Form<SphereR3> {
    SphereR3Form() {
    }

    public String tag() {
        return "sphere";
    }

    public Class<?> type() {
        return SphereR3.class;
    }

    @Override
    public double getXMin(SphereR3 sphere) {
        return sphere.xMin();
    }

    @Override
    public double getYMin(SphereR3 sphere) {
        return sphere.yMin();
    }

    @Override
    public double getZMin(SphereR3 sphere) {
        return sphere.zMin();
    }

    @Override
    public double getXMax(SphereR3 sphere) {
        return sphere.xMax();
    }

    @Override
    public double getYMax(SphereR3 sphere) {
        return sphere.yMax();
    }

    @Override
    public double getZMax(SphereR3 sphere) {
        return sphere.zMax();
    }

    @Override
    public boolean contains(SphereR3 outer, SphereR3 inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(SphereR3 s, SphereR3 t) {
        return s.intersects(t);
    }

    public Item mold(SphereR3 sphere) {
        if (sphere != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)4).item(sphere.cx).item(sphere.cy).item(sphere.cz).item(sphere.r));
        }
        return Item.extant();
    }

    public SphereR3 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            double cx = header.getItem(0).doubleValue(0.0);
            double cy = header.getItem(1).doubleValue(0.0);
            double cz = header.getItem(2).doubleValue(0.0);
            double r = header.getItem(3).doubleValue(0.0);
            return new SphereR3(cx, cy, cz, r);
        }
        return null;
    }
}

