/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorArrayIdentitySpace;
import swim.math.TensorArraySpaceForm;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.TensorSpace;

public abstract class TensorArraySpace<T, V, S>
implements TensorSpace<T, S> {
    public abstract TensorSpace<V, S> next();

    public abstract T of(Object ... var1);

    public abstract Object[] toArray(T var1);

    public TensorForm<T> form(TensorForm<V> next) {
        return new TensorArraySpaceForm(this, next);
    }

    protected Object[] newArray(int length) {
        return new Object[length];
    }

    @Override
    public T zero() {
        int n = this.dimensions().size;
        Object[] ws = new Object[n];
        V zero = this.next().zero();
        for (int i = 0; i < n; ++i) {
            ws[i] = zero;
        }
        return this.of(ws);
    }

    @Override
    public T add(T u, T v) {
        Object[] vs;
        Object[] us = this.toArray(u);
        int n = us.length;
        if (n != (vs = this.toArray(v)).length) {
            throw new DimensionException();
        }
        Object[] ws = this.newArray(n);
        TensorSpace<Object, S> next = this.next();
        for (int i = 0; i < n; ++i) {
            ws[i] = next.add(us[i], vs[i]);
        }
        return this.of(ws);
    }

    @Override
    public T opposite(T v) {
        Object[] vs = this.toArray(v);
        int n = vs.length;
        Object[] ws = this.newArray(n);
        TensorSpace<Object, S> next = this.next();
        for (int i = 0; i < n; ++i) {
            ws[i] = next.opposite(vs[i]);
        }
        return this.of(ws);
    }

    @Override
    public T subtract(T u, T v) {
        Object[] vs;
        Object[] us = this.toArray(u);
        int n = us.length;
        if (n != (vs = this.toArray(v)).length) {
            throw new DimensionException();
        }
        Object[] ws = this.newArray(n);
        TensorSpace<Object, S> next = this.next();
        for (int i = 0; i < n; ++i) {
            ws[i] = next.subtract(us[i], vs[i]);
        }
        return this.of(ws);
    }

    @Override
    public T multiply(T u, S a) {
        Object[] us = this.toArray(u);
        int n = us.length;
        Object[] ws = this.newArray(n);
        TensorSpace<Object, S> next = this.next();
        for (int i = 0; i < n; ++i) {
            ws[i] = next.multiply(us[i], a);
        }
        return this.of(ws);
    }

    @Override
    public T combine(S a, T u, S b, T v) {
        Object[] vs;
        Object[] us = this.toArray(u);
        int n = us.length;
        if (n != (vs = this.toArray(v)).length) {
            throw new DimensionException();
        }
        Object[] ws = this.newArray(n);
        TensorSpace<Object, S> next = this.next();
        for (int i = 0; i < n; ++i) {
            ws[i] = next.combine(a, us[i], b, vs[i]);
        }
        return this.of(ws);
    }

    public static <V, S> TensorArraySpace<V[], V, S> from(Class<V> type, TensorSpace<V, S> next, TensorDims dims) {
        return new TensorArrayIdentitySpace<V, S>(type, next, dims);
    }

    public static <V, S> TensorArraySpace<V[], V, S> from(Class<V> type, TensorSpace<V, S> next, int n) {
        return new TensorArrayIdentitySpace<V, S>(type, next, next.dimensions().by(n));
    }
}

