/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.VectorR2;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class VectorR2Form
extends TensorForm<VectorR2> {
    VectorR2Form() {
    }

    public String tag() {
        return "vector";
    }

    public VectorR2 unit() {
        return VectorR2.zero();
    }

    public Class<?> type() {
        return VectorR2.class;
    }

    public Item mold(VectorR2 vector) {
        if (vector != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)2).item(vector.x).item(vector.y));
        }
        return Item.extant();
    }

    public VectorR2 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            double x = header.getItem(0).doubleValue(0.0);
            double y = header.getItem(1).doubleValue(0.0);
            return new VectorR2(x, y);
        }
        return null;
    }

    @Override
    public VectorR2 fromTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        double x = tensor[offset];
        double y = tensor[offset += dim.stride];
        return new VectorR2(x, y);
    }

    @Override
    public VectorR2 fromTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        double x = tensor[offset];
        double y = tensor[offset += dim.stride];
        return new VectorR2(x, y);
    }

    @Override
    public void toTensor(VectorR2 vector, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = (float)vector.x;
        tensor[offset += dim.stride] = (float)vector.y;
    }

    @Override
    public void toTensor(VectorR2 vector, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
    }

    @Override
    public Item moldTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)2);
        header.item(tensor[offset]);
        header.item(tensor[offset += dim.stride]);
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public Item moldTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)2);
        header.item(tensor[offset]);
        header.item(tensor[offset += dim.stride]);
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(1).floatValue(0.0f);
        }
    }

    @Override
    public void castTensor(Item item, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 2 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(1).doubleValue(0.0);
        }
    }
}

