/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.TensorForm;
import swim.math.VectorR2;
import swim.math.VectorZ2Form;
import swim.math.Z2ToR2Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class VectorZ2
implements Debug {
    public final long x;
    public final long y;
    private static int hashSeed;
    private static VectorZ2 zero;
    private static TensorForm<VectorZ2> form;

    public VectorZ2(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public final VectorZ2 plus(VectorZ2 that) {
        return new VectorZ2(this.x + that.x, this.y + that.y);
    }

    public final VectorZ2 opposite() {
        return new VectorZ2(-this.x, -this.y);
    }

    public final VectorZ2 minus(VectorZ2 that) {
        return new VectorZ2(this.x - that.x, this.y - that.y);
    }

    public final VectorZ2 times(long scalar) {
        return new VectorZ2(this.x * scalar, this.y * scalar);
    }

    public VectorR2 transform(Z2ToR2Function f) {
        return new VectorR2(f.transformX(this.x, this.y), f.transformY(this.x, this.y));
    }

    public Value toValue() {
        return VectorZ2.form().mold(this).toValue();
    }

    protected boolean canEqual(VectorZ2 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VectorZ2) {
            VectorZ2 that = (VectorZ2)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(VectorZ2.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.x)), (int)Murmur3.hash((long)this.y)));
    }

    public void debug(Output<?> output) {
        output.write("VectorZ2").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static VectorZ2 zero() {
        if (zero == null) {
            zero = new VectorZ2(0L, 0L);
        }
        return zero;
    }

    public static VectorZ2 of(long x, long y) {
        return new VectorZ2(x, y);
    }

    @Kind
    public static TensorForm<VectorZ2> form() {
        if (form == null) {
            form = new VectorZ2Form();
        }
        return form;
    }
}

